/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.mobicents.slee.container.deployment.jboss.SLEEDeployer;

public class SleeStateJMXMonitor
implements NotificationListener {
    private static final Logger logger = Logger.getLogger(SleeStateJMXMonitor.class);
    private SLEEDeployer sleeDeployer;
    private int sleeState = 0;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private boolean registredSleeManagementMBeanNotificationListener = false;
    private boolean isSleeInitialized = false;

    public SleeStateJMXMonitor(SLEEDeployer sleeDeployer) {
        this.sleeDeployer = sleeDeployer;
    }

    public SleeState getSleeState() {
        return SleeState.fromInt((int)this.getSleeStateAsInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSleeStateAsInt() {
        SleeStateJMXMonitor sleeStateJMXMonitor = this;
        synchronized (sleeStateJMXMonitor) {
            if (!this.registredSleeManagementMBeanNotificationListener) {
                try {
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    server.addNotificationListener(ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                    ObjectName sleeManagementMbeanObjectName = ObjectName.getInstance("javax.slee.management:name=SleeManagement");
                    if (server.isRegistered(sleeManagementMbeanObjectName) && !this.registredSleeManagementMBeanNotificationListener) {
                        this.registerSleeManagementMBeanNotificationListener(server, sleeManagementMbeanObjectName);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                }
            }
            return this.sleeState;
        }
    }

    private void registerSleeManagementMBeanNotificationListener(MBeanServer server, ObjectName sleeManagementMbeanObjectName) throws ListenerNotFoundException, InstanceNotFoundException, MalformedObjectNameException, NullPointerException, ReflectionException, MBeanException {
        if (!this.registredSleeManagementMBeanNotificationListener) {
            try {
                server.removeNotificationListener(ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate"), this);
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
            server.addNotificationListener(sleeManagementMbeanObjectName, this, null, null);
            this.registredSleeManagementMBeanNotificationListener = true;
            SleeState sleeState = (SleeState)server.invoke(sleeManagementMbeanObjectName, "getState", EMPTY_OBJECT_ARRAY, EMPTY_STRING_ARRAY);
            this.setSleeState(sleeState);
        }
    }

    private void setSleeState(SleeState newSleeState) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setSleeState: value = " + newSleeState.toString()));
        }
        if (this.sleeState != newSleeState.toInt()) {
            this.sleeState = newSleeState.toInt();
            if (newSleeState == SleeState.RUNNING) {
                this.sleeDeployer.sleeIsRunning();
            }
        }
    }

    public void handleNotification(final Notification notification, Object handback) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SleeStateJMXMonitor sleeStateJMXMonitor = SleeStateJMXMonitor.this;
                synchronized (sleeStateJMXMonitor) {
                    if (SleeStateJMXMonitor.this.isSleeInitialized && notification instanceof SleeStateChangeNotification) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("received slee state change jmx notification " + notification));
                        }
                        SleeStateChangeNotification sscn = (SleeStateChangeNotification)notification;
                        SleeStateJMXMonitor.this.setSleeState(sscn.getNewState());
                    } else if (notification instanceof MBeanServerNotification) {
                        MBeanServerNotification mbsn = (MBeanServerNotification)notification;
                        try {
                            ObjectName sleeManagementMbeanObjectName = ObjectName.getInstance("javax.slee.management:name=SleeManagement");
                            if (mbsn.getType().equals("JMX.mbean.registered") && mbsn.getMBeanName().equals(sleeManagementMbeanObjectName)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("received slee management mbean registration jmx notification " + notification));
                                }
                                SleeStateJMXMonitor.this.registerSleeManagementMBeanNotificationListener(MBeanServerLocator.locateJBoss(), sleeManagementMbeanObjectName);
                                SleeStateJMXMonitor.this.isSleeInitialized = true;
                            }
                        }
                        catch (Throwable e) {
                            logger.error((Object)e.getMessage(), e);
                        }
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    public boolean isSleeRunning() {
        return this.sleeState == SleeState.RUNNING.toInt();
    }
}

