/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.test.ClassPoolTest;

public class ScopedSiblingDelegatingClassPoolTestCase
extends ClassPoolTest {
    public ScopedSiblingDelegatingClassPoolTestCase(String name) {
        super(name);
    }

    public void testNoVisibilityBetweenSiblings() throws Exception {
        AbstractClassPoolDomain root = ScopedSiblingDelegatingClassPoolTestCase.createClassPoolDomain("ROOT", null, false);
        AbstractClassPoolDomain domainA = ScopedSiblingDelegatingClassPoolTestCase.createClassPoolDomain("A", (ClassPoolDomain)root, false);
        DelegatingClassPool poolA = ScopedSiblingDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domainA, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain domainB = ScopedSiblingDelegatingClassPoolTestCase.createClassPoolDomain("B", (ClassPoolDomain)root, false);
        DelegatingClassPool poolB = ScopedSiblingDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domainB, SupportArchives.JAR_B_URL);
        this.accessNoVisibilityBetweenSiblings((ClassPool)poolA, (ClassPool)poolB);
        this.accessNoVisibilityBetweenSiblings((ClassPool)poolA, (ClassPool)poolB);
    }

    public void accessNoVisibilityBetweenSiblings(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass a = poolA.get(SupportClasses.CLASS_A);
        ScopedSiblingDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)a.getClassPool());
        CtClass b = poolB.get(SupportClasses.CLASS_B);
        ScopedSiblingDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)b.getClassPool());
        try {
            poolA.get(SupportClasses.CLASS_B);
            ScopedSiblingDelegatingClassPoolTestCase.fail((String)"Should not have found B in poolA");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            poolB.get(SupportClasses.CLASS_A);
            ScopedSiblingDelegatingClassPoolTestCase.fail((String)"Should not have found A in poolB");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testUsesOwnCopy() throws Exception {
        AbstractClassPoolDomain root = ScopedSiblingDelegatingClassPoolTestCase.createClassPoolDomain("ROOT", null, false);
        AbstractClassPoolDomain domainA = ScopedSiblingDelegatingClassPoolTestCase.createClassPoolDomain("A", (ClassPoolDomain)root, false);
        DelegatingClassPool poolA = ScopedSiblingDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domainA, SupportArchives.JAR_A_URL, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain domainB = ScopedSiblingDelegatingClassPoolTestCase.createClassPoolDomain("B", (ClassPoolDomain)root, false);
        DelegatingClassPool poolB = ScopedSiblingDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domainB, SupportArchives.JAR_B_URL, SupportArchives.JAR_A_URL);
        this.accessUsesOwnCopy((ClassPool)poolA, (ClassPool)poolB);
        this.accessUsesOwnCopy((ClassPool)poolA, (ClassPool)poolB);
    }

    public void accessUsesOwnCopy(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass aa = poolA.get(SupportClasses.CLASS_A);
        ScopedSiblingDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)aa.getClassPool());
        CtClass ab = poolA.get(SupportClasses.CLASS_A);
        ScopedSiblingDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)ab.getClassPool());
        CtClass ba = poolB.get(SupportClasses.CLASS_A);
        ScopedSiblingDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)ba.getClassPool());
        CtClass bb = poolB.get(SupportClasses.CLASS_B);
        ScopedSiblingDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)bb.getClassPool());
    }
}

