/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RangeDataset", inputsClass=Inputs.class)
public final class RangeDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "RangeDataset";
    private Output<? extends TType> handle;

    public RangeDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static RangeDataset create(Scope scope, Operand<TInt64> start, Operand<TInt64> stop, Operand<TInt64> step, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(start.asOutput());
        opBuilder.addInput(stop.asOutput());
        opBuilder.addInput(step.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.metadata != null) {
                    opBuilder.setAttr("metadata", opts.metadata);
                }
                if (opts.replicateOnSplit == null) continue;
                opBuilder.setAttr("replicate_on_split", opts.replicateOnSplit);
            }
        }
        return new RangeDataset(opBuilder.build());
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public static Options replicateOnSplit(Boolean replicateOnSplit) {
        return new Options().replicateOnSplit(replicateOnSplit);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=RangeDataset.class)
    public static class Inputs
    extends RawOpInputs<RangeDataset> {
        public final Operand<TInt64> start;
        public final Operand<TInt64> stop;
        public final Operand<TInt64> step;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String metadata;
        public final boolean replicateOnSplit;

        public Inputs(GraphOperation op) {
            super(new RangeDataset(op), op, Arrays.asList("output_types", "output_shapes", "metadata", "replicate_on_split"));
            int inputIndex = 0;
            this.start = op.input(inputIndex++);
            this.stop = op.input(inputIndex++);
            this.step = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
            this.replicateOnSplit = op.attributes().getAttrBool("replicate_on_split");
        }
    }

    public static class Options {
        private String metadata;
        private Boolean replicateOnSplit;

        private Options() {
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Options replicateOnSplit(Boolean replicateOnSplit) {
            this.replicateOnSplit = replicateOnSplit;
            return this;
        }
    }
}

