/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizeV2", inputsClass=Inputs.class)
public final class Quantize<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizeV2";
    private Output<T> output;
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public Quantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static <T extends TNumber> Quantize<T> create(Scope scope, Operand<TFloat32> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Class<T> T, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Quantize");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(minRange.asOutput());
        opBuilder.addInput(maxRange.asOutput());
        opBuilder.setAttr("T", Operands.toDataType(T));
        if (options != null) {
            for (Options opts : options) {
                if (opts.mode != null) {
                    opBuilder.setAttr("mode", opts.mode);
                }
                if (opts.roundMode != null) {
                    opBuilder.setAttr("round_mode", opts.roundMode);
                }
                if (opts.narrowRange != null) {
                    opBuilder.setAttr("narrow_range", opts.narrowRange);
                }
                if (opts.axis != null) {
                    opBuilder.setAttr("axis", opts.axis);
                }
                if (opts.ensureMinimumRange == null) continue;
                opBuilder.setAttr("ensure_minimum_range", opts.ensureMinimumRange.floatValue());
            }
        }
        return new Quantize<T>(opBuilder.build());
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public static Options ensureMinimumRange(Float ensureMinimumRange) {
        return new Options().ensureMinimumRange(ensureMinimumRange);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    @OpInputsMetadata(outputsClass=Quantize.class)
    public static class Inputs
    extends RawOpInputs<Quantize<?>> {
        public final Operand<TFloat32> input;
        public final Operand<TFloat32> minRange;
        public final Operand<TFloat32> maxRange;
        public final DataType T;
        public final String mode;
        public final String roundMode;
        public final boolean narrowRange;
        public final long axis;
        public final float ensureMinimumRange;

        public Inputs(GraphOperation op) {
            super(new Quantize(op), op, Arrays.asList("T", "mode", "round_mode", "narrow_range", "axis", "ensure_minimum_range"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.minRange = op.input(inputIndex++);
            this.maxRange = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.mode = op.attributes().getAttrString("mode");
            this.roundMode = op.attributes().getAttrString("round_mode");
            this.narrowRange = op.attributes().getAttrBool("narrow_range");
            this.axis = op.attributes().getAttrInt("axis");
            this.ensureMinimumRange = op.attributes().getAttrFloat("ensure_minimum_range");
        }
    }

    public static class Options {
        private String mode;
        private String roundMode;
        private Boolean narrowRange;
        private Long axis;
        private Float ensureMinimumRange;

        private Options() {
        }

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        public Options ensureMinimumRange(Float ensureMinimumRange) {
            this.ensureMinimumRange = ensureMinimumRange;
            return this;
        }
    }
}

