/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.img;

import cn.hutool.core.img.FontUtil;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class Img
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedImage srcImage;
    private Image targetImage;
    private String targetImageType;
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;

    public static Img from(Path imagePath) {
        return Img.from(imagePath.toFile());
    }

    public static Img from(File imageFile) {
        return new Img(ImgUtil.read(imageFile));
    }

    public static Img from(Resource resource) {
        return Img.from(resource.getStream());
    }

    public static Img from(InputStream in) {
        return new Img(ImgUtil.read(in));
    }

    public static Img from(ImageInputStream imageStream) {
        return new Img(ImgUtil.read(imageStream));
    }

    public static Img from(URL imageUrl) {
        return new Img(ImgUtil.read(imageUrl));
    }

    public static Img from(Image image) {
        return new Img(ImgUtil.toBufferedImage(image));
    }

    public Img(BufferedImage srcImage) {
        this(srcImage, null);
    }

    public Img(BufferedImage srcImage, String targetImageType) {
        this.srcImage = srcImage;
        if (null == targetImageType) {
            targetImageType = "jpg";
        }
        this.targetImageType = targetImageType;
    }

    public Img setTargetImageType(String imgType) {
        this.targetImageType = imgType;
        return this;
    }

    public Img setPositionBaseCentre(boolean positionBaseCentre) {
        this.positionBaseCentre = positionBaseCentre;
        return this;
    }

    public Img setQuality(double quality) {
        return this.setQuality((float)quality);
    }

    public Img setQuality(float quality) {
        this.quality = quality > 0.0f && quality < 1.0f ? quality : 1.0f;
        return this;
    }

    public Img scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        Image srcImg = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), null);
            this.targetImage = op.filter(ImgUtil.toBufferedImage(srcImg), null);
        } else {
            String scaleStr = Float.toString(scale);
            int width = NumberUtil.mul(Integer.toString(srcImg.getWidth(null)), scaleStr).intValue();
            int height = NumberUtil.mul(Integer.toString(srcImg.getHeight(null)), scaleStr).intValue();
            this.scale(width, height);
        }
        return this;
    }

    public Img scale(int width, int height) {
        Image srcImg = this.getValidSrcImg();
        int srcHeight = srcImg.getHeight(null);
        int srcWidth = srcImg.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImg;
            return this;
        }
        int scaleType = srcHeight < height || srcWidth < width ? 4 : 1;
        double sx = NumberUtil.div((float)width, (float)srcWidth);
        double sy = NumberUtil.div((float)height, (float)srcHeight);
        if ("png".equals(this.targetImageType)) {
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(sx, sy), null);
            this.targetImage = op.filter(ImgUtil.toBufferedImage(srcImg), null);
        } else {
            this.targetImage = srcImg.getScaledInstance(width, height, scaleType);
        }
        return this;
    }

    public Img scale(int width, int height, Color fixedColor) {
        Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = NumberUtil.div((float)height, (float)srcHeight);
        double widthRatio = NumberUtil.div((float)width, (float)srcWidth);
        if (widthRatio == heightRatio) {
            this.scale(width, height);
        } else if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        srcImage = this.getValidSrcImg();
        srcHeight = srcImage.getHeight(null);
        srcWidth = srcImage.getWidth(null);
        BufferedImage image = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D g = image.createGraphics();
        if (null != fixedColor) {
            g.setBackground(fixedColor);
            g.clearRect(0, 0, width, height);
        }
        g.drawImage(srcImage, (width - srcWidth) / 2, (height - srcHeight) / 2, srcWidth, srcHeight, fixedColor, null);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public Img cut(Rectangle rectangle) {
        Image srcImage = this.getValidSrcImg();
        this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(srcImage.getSource(), cropFilter));
        this.targetImage = ImgUtil.toBufferedImage(image);
        return this;
    }

    public Img cut(int x, int y) {
        return this.cut(x, y, -1);
    }

    public Img cut(int x, int y, int radius) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        int diameter = radius > 0 ? radius * 2 : Math.min(width, height);
        BufferedImage targetImage = new BufferedImage(diameter, diameter, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setClip(new Ellipse2D.Double(0.0, 0.0, diameter, diameter));
        if (this.positionBaseCentre) {
            x = x - width / 2 + diameter / 2;
            y = y - height / 2 + diameter / 2;
        }
        g.drawImage(srcImage, x, y, null);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Img round(double arc) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        arc = NumberUtil.mul(arc, (float)Math.min(width, height));
        BufferedImage targetImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = targetImage.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(srcImage, 0, 0, null);
        g2.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Img gray() {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.targetImage = op.filter(ImgUtil.toBufferedImage(this.getValidSrcImg()), null);
        return this;
    }

    public Img binary() {
        this.targetImage = ImgUtil.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    public Img pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        BufferedImage targetImage = ImgUtil.toBufferedImage(this.getValidSrcImg());
        Graphics2D g = targetImage.createGraphics();
        if (null == font) {
            font = FontUtil.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        if (this.positionBaseCentre) {
            GraphicsUtil.drawString((Graphics)g, pressText, font, color, new Rectangle(x, y, targetImage.getWidth(), targetImage.getHeight()));
        } else {
            GraphicsUtil.drawString((Graphics)g, pressText, font, color, new Point(x, y));
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Img pressImage(Image pressImg, int x, int y, float alpha) {
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        return this.pressImage(pressImg, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public Img pressImage(Image pressImg, Rectangle rectangle, float alpha) {
        Image targetImg = this.getValidSrcImg();
        this.targetImage = this.draw(ImgUtil.toBufferedImage(targetImg), pressImg, rectangle, alpha);
        return this;
    }

    public Img rotate(int degree) {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = Img.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.translate((double)(rectangle.width - width) / 2.0, (double)(rectangle.height - height) / 2.0);
        graphics2d.rotate(Math.toRadians(degree), (double)width / 2.0, (double)height / 2.0);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Img flip() {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Image getImg() {
        return null == this.targetImage ? this.srcImage : this.targetImage;
    }

    public boolean write(OutputStream out) throws IORuntimeException {
        return this.write(ImgUtil.getImageOutputStream(out));
    }

    public boolean write(ImageOutputStream targetImageStream) throws IORuntimeException {
        Assert.notBlank(this.targetImageType, "Target image type is blank !", new Object[0]);
        Assert.notNull(targetImageStream, "Target output stream is null !", new Object[0]);
        Image targetImage = null == this.targetImage ? this.srcImage : this.targetImage;
        Assert.notNull(targetImage, "Target image is null !", new Object[0]);
        return ImgUtil.write(targetImage, this.targetImageType, targetImageStream, this.quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File targetFile) throws IORuntimeException {
        String formatName = FileUtil.extName(targetFile);
        if (StrUtil.isNotBlank(formatName)) {
            this.targetImageType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ImageOutputStream out = null;
        try {
            out = ImgUtil.getImageOutputStream(targetFile);
            boolean bl = this.write(out);
            return bl;
        }
        finally {
            IoUtil.close(out);
        }
    }

    private BufferedImage draw(BufferedImage backgroundImg, Image img, Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        GraphicsUtil.setAlpha(g, alpha);
        Point point = this.positionBaseCentre ? ImgUtil.getPointBaseCentre(rectangle, backgroundImg.getWidth(), backgroundImg.getHeight()) : new Point(rectangle.x, rectangle.y);
        rectangle.setLocation(point.x, point.y);
        GraphicsUtil.drawImg((Graphics)g, img, rectangle);
        g.dispose();
        return backgroundImg;
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return ObjectUtil.defaultIfNull(this.targetImage, this.srcImage);
    }

    private Rectangle fixRectangle(Rectangle rectangle, int baseWidth, int baseHeight) {
        if (this.positionBaseCentre) {
            rectangle.setLocation(rectangle.x + Math.abs(baseWidth - rectangle.width) / 2, rectangle.y + Math.abs(baseHeight - rectangle.height) / 2);
        }
        return rectangle;
    }

    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        if (degree < 0) {
            degree += 360;
        }
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        double r = Math.sqrt(height * height + width * width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angel_dalta_width = Math.atan((double)height / (double)width);
        double angel_dalta_height = Math.atan((double)width / (double)height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = width + len_dalta_width * 2;
        int des_height = height + len_dalta_height * 2;
        return new Rectangle(des_width, des_height);
    }
}

