/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery;

import cn.jimmyshi.beanquery.DefaultNullValuePropertyValueGetter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyMatcher<T>
extends BaseMatcher<T> {
    private transient Logger logger = LoggerFactory.getLogger(BeanPropertyMatcher.class);
    private String property;
    private Matcher<?> matcher;

    public BeanPropertyMatcher(String property, Matcher<?> matcher) {
        this.property = property;
        this.matcher = matcher;
    }

    public boolean matches(Object item) {
        Object propertyValue = DefaultNullValuePropertyValueGetter.getProperty(item, this.property);
        try {
            return this.matcher.matches(propertyValue);
        }
        catch (Exception ex) {
            this.logger.info("Exception [{}] when matching value [{}] (property [{}] of item [{}]) with matcher [{}]", new Object[]{ex.toString(), propertyValue, this.property, item, this.matcher});
            return false;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false);
    }

    public void describeTo(Description description) {
        description.appendText(this.toString());
    }
}

