/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery.selectors;

import cn.jimmyshi.beanquery.selectors.CompositeSelector;
import cn.jimmyshi.beanquery.selectors.KeyValueMapSelector;
import cn.jimmyshi.beanquery.selectors.PropertySelector;
import java.beans.PropertyDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassSelector
extends KeyValueMapSelector {
    private transient Logger logger = LoggerFactory.getLogger(ClassSelector.class);
    private List<PropertySelector> propertySelectors = new LinkedList<PropertySelector>();
    private CompositeSelector compositeSelector = new CompositeSelector();

    public ClassSelector(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        if (null == clazz) {
            this.logger.warn("Input class is null");
            return;
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(clazz)) {
            boolean propertyReadable = propertyDescriptor.getReadMethod() != null;
            String propertyName = propertyDescriptor.getName();
            if ("class".equals(propertyName) || !propertyReadable) continue;
            PropertySelector propertySelector = new PropertySelector(propertyDescriptor.getName());
            this.propertySelectors.add(propertySelector);
            this.compositeSelector.addSubSelector(propertySelector);
        }
    }

    public ClassSelector except(String ... propertyNames) {
        if (ArrayUtils.isEmpty((Object[])propertyNames)) {
            return this;
        }
        boolean updated = false;
        for (String propertyToRemove : propertyNames) {
            if (!this.removePropertySelector(propertyToRemove)) continue;
            updated = true;
        }
        if (updated) {
            this.compositeSelector = new CompositeSelector(this.propertySelectors);
        }
        return this;
    }

    private boolean removePropertySelector(String propertyName) {
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return false;
        }
        for (PropertySelector selector : this.propertySelectors) {
            if (!selector.getProperty().equals(propertyName)) continue;
            this.propertySelectors.remove(selector);
            return true;
        }
        return false;
    }

    public ClassSelector add(String ... propertyNames) {
        if (ArrayUtils.isNotEmpty((Object[])propertyNames)) {
            for (String propertyNameToAdd : propertyNames) {
                this.addPropertySelector(propertyNameToAdd);
            }
        }
        return this;
    }

    private void addPropertySelector(String propertyNameToAdd) {
        if (StringUtils.isBlank((CharSequence)propertyNameToAdd)) {
            return;
        }
        for (PropertySelector propertySelector : this.propertySelectors) {
            if (!propertySelector.getProperty().equals(propertyNameToAdd)) continue;
            return;
        }
        PropertySelector newPropertySelector = new PropertySelector(propertyNameToAdd);
        this.propertySelectors.add(newPropertySelector);
        this.compositeSelector.addSubSelector(newPropertySelector);
    }

    @Override
    protected Map<String, Object> doSelect(Object item) {
        return this.compositeSelector.select(item);
    }
}

