/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery.selectors;

import cn.jimmyshi.beanquery.selectors.KeyValueMapSelector;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class NestedKeyValueMapSelector
extends KeyValueMapSelector {
    private KeyValueMapSelector selector;

    public NestedKeyValueMapSelector(KeyValueMapSelector sourceSelector) {
        this.selector = sourceSelector;
    }

    @Override
    protected Map<String, Object> doSelect(Object item) {
        Object originalResult = this.selector.select(item);
        if (MapUtils.isEmpty((Map)originalResult)) {
            return originalResult;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry originalItem : originalResult.entrySet()) {
            String key = (String)originalItem.getKey();
            Object value = originalItem.getValue();
            if (StringUtils.isBlank((CharSequence)key) || !key.contains(".")) {
                result.put(key, value);
                continue;
            }
            this.addNestedKeyValue(key, value, result);
        }
        return result;
    }

    private void addNestedKeyValue(String key, Object value, Map<String, Object> container) {
        if (!key.contains(".")) {
            container.put(key, value);
            return;
        }
        String firstKey = StringUtils.substringBefore((String)key, (String)".");
        Map<String, Object> subContainer = new LinkedHashMap<String, Object>();
        if (container.containsKey(firstKey)) {
            Object originalValue = container.get(firstKey);
            if (subContainer.getClass().isAssignableFrom(originalValue.getClass())) {
                subContainer = (Map)originalValue;
            } else {
                subContainer.put("", originalValue);
                container.put(firstKey, subContainer);
            }
        } else {
            container.put(firstKey, subContainer);
        }
        this.addNestedKeyValue(StringUtils.substringAfter((String)key, (String)"."), value, subContainer);
    }
}

