/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.services.waf.model.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Rule
implements Serializable,
Cloneable {
    private String ruleId;
    private String name;
    private String metricName;
    private List<Predicate> predicates;

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public Rule withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Rule withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(Collection<Predicate> predicates) {
        if (predicates == null) {
            this.predicates = null;
            return;
        }
        this.predicates = new ArrayList<Predicate>(predicates);
    }

    public Rule withPredicates(Predicate ... predicates) {
        if (this.predicates == null) {
            this.setPredicates(new ArrayList<Predicate>(predicates.length));
        }
        for (Predicate ele : predicates) {
            this.predicates.add(ele);
        }
        return this;
    }

    public Rule withPredicates(Collection<Predicate> predicates) {
        this.setPredicates(predicates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleId() != null) {
            sb.append("RuleId: " + this.getRuleId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: " + this.getMetricName() + ",");
        }
        if (this.getPredicates() != null) {
            sb.append("Predicates: " + this.getPredicates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getPredicates() == null ^ this.getPredicates() == null) {
            return false;
        }
        return other.getPredicates() == null || other.getPredicates().equals(this.getPredicates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getPredicates() == null ? 0 : this.getPredicates().hashCode());
        return hashCode;
    }

    public Rule clone() {
        try {
            return (Rule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

