/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.BasePrepareStatement;
import com.oceanbase.jdbc.JDBC4ServerCallableStatement;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseParameterMetaData;
import com.oceanbase.jdbc.OceanBaseResultSetMetaData;
import com.oceanbase.jdbc.ReturnParameter;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.send.parameters.NullParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ClientPrepareResult;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.util.OceanBaseCRC32C;
import java.io.UnsupportedEncodingException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;

public class JDBC4ServerPreparedStatement
extends BasePrepareStatement
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(JDBC4ServerPreparedStatement.class);
    private List<ReturnParameter> returnParams = new ArrayList<ReturnParameter>();
    private int returnParamCount = 0;
    protected Map<Integer, ParameterHolder> currentParameterHolder;
    protected List<ParameterHolder[]> parametersList = new ArrayList<ParameterHolder[]>();
    protected ServerPrepareResult serverPrepareResult = null;
    private OceanBaseResultSetMetaData resultSetMetaData;
    private OceanBaseParameterMetaData parameterMetaData;
    private boolean released;
    protected boolean isObFunction;
    private boolean sendTypesToServer = false;
    private boolean mustExecuteOnMaster;
    private int iterationCount;
    private int executeMode = 0;
    private long checksum = 1L;
    private OceanBaseCRC32C crc32C = new OceanBaseCRC32C();

    public JDBC4ServerPreparedStatement(boolean isObFunction, OceanBaseConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, exceptionFactory);
        this.isObFunction = isObFunction;
        this.currentParameterHolder = Collections.synchronizedMap(new TreeMap());
        this.mustExecuteOnMaster = this.protocol.isMasterConnection();
        this.originalSql = sql;
        Utils.TrimSQLInfo tmp = Utils.trimSQLStringInternal(this.originalSql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), false);
        this.simpleSql = tmp.getTrimedString();
        this.selectEndPos = tmp.getSelectEndPos();
        this.whereEndPos = tmp.getWhereEndPos();
        this.sqlType = Utils.getStatementType(this.simpleSql);
        this.actualSql = this.originalSql;
        if (!(!this.protocol.isOracleMode() || this.sqlType != 1 || resultSetScrollType == 1003 && resultSetConcurrency == 1007 || resultSetScrollType == 1004 && resultSetConcurrency == 1007)) {
            this.addRowid = true;
            this.actualSql = this.actualSql.substring(0, this.selectEndPos + 1) + " rowid," + this.actualSql.substring(this.selectEndPos + 1);
        }
        this.initializeReturnParams();
        if (!this.protocol.isOracleMode()) {
            if (!this.simpleSql.startsWith("CALL") && !this.simpleSql.startsWith("call")) {
                this.prepare(this.actualSql);
            }
        } else if (!this.protocol.supportStmtPrepareExecute()) {
            this.prepare(this.actualSql);
        } else {
            this.parameterCount = tmp.getParamCount();
        }
    }

    @Override
    public JDBC4ServerPreparedStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        JDBC4ServerPreparedStatement clone = (JDBC4ServerPreparedStatement)super.clone(connection);
        clone.released = false;
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        clone.parametersList = new ArrayList<ParameterHolder[]>();
        clone.isObFunction = this.isObFunction;
        clone.mustExecuteOnMaster = this.mustExecuteOnMaster;
        clone.originalSql = this.originalSql;
        clone.simpleSql = this.simpleSql;
        clone.selectEndPos = this.selectEndPos;
        clone.whereEndPos = this.whereEndPos;
        clone.sqlType = this.sqlType;
        clone.actualSql = this.actualSql;
        clone.addRowid = this.addRowid;
        try {
            if (!clone.protocol.isOracleMode()) {
                if (!this.simpleSql.startsWith("CALL") && !this.simpleSql.startsWith("call")) {
                    clone.prepare(this.actualSql);
                }
            } else {
                if (clone.protocol.supportStmtPrepareExecute()) {
                    clone.parameterCount = this.parameterCount;
                }
                clone.prepare(this.actualSql);
            }
        }
        catch (SQLException e) {
            throw new CloneNotSupportedException("PrepareStatement not ");
        }
        return clone;
    }

    private void initializeReturnParams() {
        int i;
        if (!this.isDml(this.sqlType)) {
            return;
        }
        String completeStmt = this.simpleSql.toLowerCase(Locale.ROOT);
        int returningStartPos = completeStmt.indexOf("returning");
        if (returningStartPos < 1 || completeStmt.charAt(returningStartPos - 1) != ' ') {
            return;
        }
        int returningEndPos = returningStartPos + "returning".length();
        if (returningEndPos >= completeStmt.length() || completeStmt.charAt(returningEndPos) != ' ') {
            return;
        }
        String returningClause = completeStmt.substring(returningStartPos);
        int intoStartPos = returningClause.indexOf("into");
        if (intoStartPos < 1 || returningClause.charAt(intoStartPos - 1) != ' ') {
            return;
        }
        int intoEndPos = intoStartPos + "into".length();
        if (intoEndPos >= returningClause.length() || returningClause.charAt(intoEndPos) != ' ') {
            return;
        }
        for (i = 0; i < returningClause.length(); ++i) {
            if (returningClause.charAt(i) != ':' && returningClause.charAt(i) != '?') continue;
            ++this.returnParamCount;
        }
        this.returnParams = new ArrayList<ReturnParameter>(this.returnParamCount);
        for (i = 0; i < this.returnParamCount; ++i) {
            this.returnParams.add(new ReturnParameter());
        }
    }

    private void degradeResultSetType() {
        this.resultSetScrollType = this.resultSetScrollType == 1005 && this.resultSetConcurrency == 1008 || this.resultSetScrollType == 1005 && this.resultSetConcurrency == 1007 || this.resultSetScrollType == 1004 && this.resultSetConcurrency == 1008 ? 1004 : 1003;
        this.resultSetConcurrency = 1007;
    }

    private void calculateCheckSum(String sql) throws SQLException {
        try {
            this.crc32C.reset();
            byte[] b = sql.getBytes(this.options.characterEncoding);
            this.crc32C.update(b, 0, b.length);
            this.checksum = this.crc32C.getValue();
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SQLException sqlException = new SQLException("sql string getBytes error" + e.getMessage());
            logger.error("error preparing query", sqlException);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(sqlException);
        }
    }

    private void prepare(String sql) throws SQLException {
        this.calculateCheckSum(sql);
        try {
            if (!this.protocol.supportStmtPrepareExecute()) {
                this.serverPrepareResult = this.protocol.prepare(sql, this.mustExecuteOnMaster);
                this.setMetaFromResult();
            }
        }
        catch (SQLException e) {
            if (this.addRowid) {
                this.degradeResultSetType();
                this.addRowid = false;
                this.actualSql = this.originalSql;
                this.prepare(this.actualSql);
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("error preparing query", e);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(e);
        }
    }

    private void setMetaFromResult() {
        this.parameterCount = this.serverPrepareResult.getParamCount();
        this.resultSetMetaData = new OceanBaseResultSetMetaData(this.serverPrepareResult.getColumns(), this.protocol.getUrlParser().getOptions(), false, this.protocol.isOracleMode(), this.addRowid ? 1 : 0);
        this.parameterMetaData = new OceanBaseParameterMetaData(this.serverPrepareResult.getParameters());
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        this.currentParameterHolder.put(parameterIndex - 1, holder);
    }

    public void registerReturnParameter(int parameterIndex, int externalType) throws SQLException {
        if (this.parameterCount <= 0) {
            throw new SQLException("The count of bind parameter must be larger than 0.");
        }
        if (this.returnParamCount <= 0) {
            throw new SQLException("The count of return parameter must be larger than 0.");
        }
        int index = parameterIndex - 1;
        if (index < this.parameterCount - this.returnParamCount || parameterIndex > this.parameterCount) {
            throw new SQLException("Invalid parameter index.");
        }
        this.setParameter(parameterIndex, new NullParameter(ColumnType.convertSqlTypeToColumnType(externalType)));
    }

    public void registerReturnParameter(int parameterIndex, int externalType, int maximumSize) throws SQLException {
        if (this.parameterCount <= 0) {
            throw new SQLException("The count of bind parameter must be larger than 0.");
        }
        int index = parameterIndex - 1;
        if (index >= 0 && parameterIndex <= this.parameterCount) {
            if (externalType != 1 && externalType != 12 && externalType != -1 && externalType != -2 && externalType != -3 && externalType != -4) {
                throw new SQLException("Invalid parameter type for this interface.");
            }
            if (maximumSize <= 0) {
                throw new SQLException("Maximum size of return parameter must be larger than 0.");
            }
        } else {
            throw new SQLException("Invalid parameter index.");
        }
        this.setParameter(parameterIndex, new NullParameter(ColumnType.convertSqlTypeToColumnType(externalType)));
    }

    public void registerReturnParameter(int parameterIndex, int externalType, String internalTypeName) throws SQLException {
        if (this.parameterCount <= 0) {
            throw new SQLException("The count of bind parameter must be larger than 0.");
        }
        int index = parameterIndex - 1;
        if (index >= 0 && parameterIndex <= this.parameterCount) {
            if (externalType != 2006 && externalType != 2002 && externalType != 2003 && externalType != 2009) {
                throw new SQLException("Invalid parameter type for this interface.");
            }
        } else {
            throw new SQLException("Invalid parameter index.");
        }
        this.setParameter(parameterIndex, new NullParameter(ColumnType.convertSqlTypeToColumnType(externalType)));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public ParameterHolder[] getParameters() {
        return this.currentParameterHolder.values().toArray(new ParameterHolder[0]);
    }

    @Override
    public void setParameters(ParameterHolder[] paramArray) {
        for (int i = 0; i < paramArray.length; ++i) {
            this.currentParameterHolder.put(i, paramArray[i]);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClose();
        this.currentParameterHolder.clear();
    }

    protected void validParameters() throws SQLException {
        if (!(this instanceof JDBC4ServerCallableStatement)) {
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder.get(i) != null) continue;
                logger.error("Parameter at position {} is not set", (Object)(i + 1));
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.returnParamCount > 0) {
            throw new SQLFeatureNotSupportedException("not support batch operation for DML_Returning_Into feature.");
        }
        this.validParameters();
        this.parametersList.add(this.currentParameterHolder.values().toArray(new ParameterHolder[0]));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.returnParamCount > 0) {
            throw new SQLException("not support batch operation for DML_Returning_Into feature.");
        }
        String querySetToServer = sql;
        Matcher matcher = OceanBaseConnection.CALLABLE_STATEMENT_PATTERN.matcher(querySetToServer);
        if (this.protocol.isOracleMode()) {
            if (matcher.matches()) {
                querySetToServer = matcher.group(2);
            }
            if (this.options.supportNameBinding) {
                querySetToServer = Utils.trimSQLString(querySetToServer, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), true);
            }
        } else if (matcher.matches()) {
            querySetToServer = matcher.group(2);
        }
        super.addBatch(querySetToServer);
    }

    @Override
    public void clearBatch() {
        this.parametersList.clear();
        this.hasLongData = false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i;
        this.checkClose();
        int[] retBatchQuery = new int[]{};
        int[] retBatch = new int[]{};
        int queryParameterSize = this.parametersList.size();
        if (queryParameterSize == 0) {
            retBatch = new int[]{};
        } else {
            this.executeBatchInternal(queryParameterSize);
            retBatch = this.results.getCmdInformation().getUpdateCounts();
        }
        if (this.batchQueries != null && this.batchQueries.size() > 0) {
            retBatchQuery = super.executeBatch();
        }
        int[] ret = new int[retBatch.length + retBatchQuery.length];
        int cur = 0;
        for (i = 0; i < retBatch.length; ++i) {
            ret[cur++] = retBatch[i];
        }
        for (i = 0; i < retBatchQuery.length; ++i) {
            ret[cur++] = retBatchQuery[i];
        }
        return ret;
    }

    public int[] executeBatchQuerys() throws SQLException {
        this.checkClose();
        int[] retBatchQuery = new int[]{};
        if (this.batchQueries != null && this.batchQueries.size() > 0) {
            retBatchQuery = super.executeBatch();
        }
        return retBatchQuery;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        int i;
        this.checkClose();
        long[] retBatchQuery = new long[]{};
        long[] retBatch = new long[]{};
        int queryParameterSize = this.parametersList.size();
        if (queryParameterSize == 0) {
            retBatch = new long[]{};
        } else {
            this.executeBatchInternal(queryParameterSize);
            retBatch = this.results.getCmdInformation().getLargeUpdateCounts();
        }
        if (this.batchQueries != null && this.batchQueries.size() > 0) {
            retBatchQuery = super.executeLargeBatch();
        }
        long[] ret = new long[retBatch.length + retBatchQuery.length];
        int cur = 0;
        for (i = 0; i < retBatch.length; ++i) {
            ret[cur++] = retBatch[i];
        }
        for (i = 0; i < retBatchQuery.length; ++i) {
            ret[cur++] = retBatchQuery[i];
        }
        return ret;
    }

    public long[] executeLargeBatchQuerys() throws SQLException {
        this.checkClose();
        long[] retBatchQuery = new long[]{};
        if (this.batchQueries != null && this.batchQueries.size() > 0) {
            retBatchQuery = super.executeLargeBatch();
        }
        return retBatchQuery;
    }

    boolean hasLongData(ParameterHolder[] parameterHolders) {
        if (parameterHolders == null) {
            return false;
        }
        for (ParameterHolder var : parameterHolders) {
            if (!var.isLongData()) continue;
            return true;
        }
        return false;
    }

    SQLException executeArrayBinding(int startIndex, int endIndex, int queryParameterSize) throws SQLException {
        SQLException exception = null;
        try {
            if (this.queryTimeout > 0) {
                this.protocol.stopIfInterrupted();
            }
            if (this.serverPrepareResult != null) {
                this.serverPrepareResult.resetParameterTypeHeader();
            }
            if (this.protocol.supportStmtPrepareExecute()) {
                int paramCount = this.parametersList.get(0).length;
                this.serverPrepareResult = this.protocol.executePreparedQueryArrayBinding(paramCount, this.mustExecuteOnMaster, this.serverPrepareResult, this.results, this.parametersList.subList(startIndex, endIndex), queryParameterSize);
            } else {
                this.protocol.executePreparedQueryArrayBinding(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, this.parametersList.subList(startIndex, endIndex), queryParameterSize);
            }
        }
        catch (SQLException queryException) {
            if (this.options.continueBatchOnError) {
                if (exception == null) {
                    exception = queryException;
                }
            }
            throw queryException;
        }
        return exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeBatchInternal(int queryParameterSize) throws SQLException {
        this.lock.lock();
        this.executing = true;
        boolean executeBatchByArrayBinding = false;
        try {
            this.executeQueryPrologue(this.serverPrepareResult);
            if (this.queryTimeout != 0 && this.options.enableQueryTimeouts) {
                this.setTimerTask(true);
            }
            int remainParameterSize = queryParameterSize;
            int currentTurnParamSize = queryParameterSize;
            boolean continueRewrite = true;
            int parameterCountReal = this.parameterCount;
            int preIndex = 0;
            ParameterHolder[] currentQueryParameters = null;
            String curString = this.originalSql;
            boolean isInsert = false;
            while (continueRewrite) {
                SQLException exception;
                block44: {
                    block51: {
                        SQLException exceptionRet;
                        block50: {
                            block49: {
                                block48: {
                                    int i;
                                    StringBuilder sb;
                                    List<String> list;
                                    block47: {
                                        block45: {
                                            block46: {
                                                if (!this.options.rewriteBatchedStatements) break block45;
                                                if (remainParameterSize * parameterCountReal > this.options.maxBatchTotalParamsNum) {
                                                    currentTurnParamSize = this.options.maxBatchTotalParamsNum / parameterCountReal;
                                                    remainParameterSize -= currentTurnParamSize;
                                                } else {
                                                    continueRewrite = false;
                                                    currentTurnParamSize = remainParameterSize;
                                                    remainParameterSize = 0;
                                                }
                                                String sqlString = curString;
                                                if (this.protocol.isOracleMode() && this.options.supportNameBinding) {
                                                    sqlString = Utils.trimSQLString(curString, this.protocol.noBackslashEscapes(), true, true);
                                                }
                                                if ((list = ClientPrepareResult.rewritablePartsInsertSql(sqlString, false, this.protocol.isOracleMode(), this.options.characterEncoding)) == null) break block46;
                                                sb = new StringBuilder();
                                                sb.append(list.get(0));
                                                sb.append(list.get(1));
                                                for (int i2 = 0; i2 < parameterCountReal; ++i2) {
                                                    sb.append('?');
                                                    sb.append(list.get(i2 + 2));
                                                }
                                                break block47;
                                            }
                                            isInsert = false;
                                            break block48;
                                        }
                                        continueRewrite = false;
                                        break block48;
                                    }
                                    for (int remain = currentTurnParamSize - 1; remain != 0; --remain) {
                                        sb.append(',');
                                        sb.append(list.get(1));
                                        for (i = 0; i < parameterCountReal; ++i) {
                                            sb.append('?');
                                            sb.append(list.get(i + 2));
                                        }
                                    }
                                    if (parameterCountReal == 0) {
                                        for (i = 2; i < list.size(); ++i) {
                                            sb.append(list.get(i));
                                        }
                                    } else {
                                        sb.append(list.get(list.size() - 1));
                                    }
                                    int total = currentTurnParamSize * parameterCountReal;
                                    ParameterHolder[] allParams = new ParameterHolder[total];
                                    int cur = 0;
                                    for (int counter = preIndex; counter < currentTurnParamSize + preIndex; ++counter) {
                                        ParameterHolder[] parameterHolder = this.parametersList.get(counter);
                                        for (int i3 = 0; i3 < parameterHolder.length; ++i3) {
                                            allParams[cur++] = parameterHolder[i3];
                                        }
                                    }
                                    queryParameterSize = 1;
                                    preIndex += currentTurnParamSize;
                                    currentQueryParameters = allParams;
                                    this.actualSql = sb.toString();
                                    this.prepare(this.actualSql);
                                    this.parameterCount = parameterCountReal;
                                    isInsert = true;
                                }
                                this.results = new Results(this, 0, true, currentTurnParamSize, true, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), null, null);
                                if (this.protocol.supportStmtPrepareExecute()) {
                                    if (this.options.useServerPrepStmts && !this.protocol.getAutocommit() && this.protocol.isOracleMode() && this.options.useArrayBinding && !this.options.rewriteBatchedStatements) {
                                        executeBatchByArrayBinding = true;
                                        this.iterationCount = 2;
                                    } else {
                                        this.iterationCount = 1;
                                    }
                                    this.executeMode |= 1;
                                    if (this.parameterCount > 0) {
                                        this.sendTypesToServer = true;
                                    }
                                    this.calculateCheckSum(this.actualSql);
                                    this.protocol.setComStmtPrepareExecuteField(this.iterationCount, this.executeMode, this.checksum);
                                } else {
                                    this.protocol.setChecksum(this.checksum);
                                }
                                if (this.options.useBatchMultiSend.booleanValue() || this.options.useBulkStmts) {
                                    this.serverPrepareResult = this.protocol.executeBatchServer(this.serverPrepareResult, this.results, this.actualSql, this.parametersList, this.hasLongData);
                                    if (this.results.getBatchSucceed()) {
                                        if (this.resultSetMetaData == null) {
                                            this.setMetaFromResult();
                                        }
                                        this.protocol.resetChecksum();
                                        this.results.commandEnd();
                                        return;
                                    }
                                }
                                exception = null;
                                exceptionRet = null;
                                if (!this.options.rewriteBatchedStatements || !isInsert) break block49;
                                this.results.setRewritten(true);
                                ParameterHolder[] parameterHolder = currentQueryParameters;
                                try {
                                    if (this.queryTimeout > 0) {
                                        this.protocol.stopIfInterrupted();
                                    }
                                    if (this.serverPrepareResult != null) {
                                        this.serverPrepareResult.resetParameterTypeHeader();
                                    }
                                    if (this.protocol.supportStmtPrepareExecute()) {
                                        this.serverPrepareResult = this.protocol.executePreparedQuery(parameterHolder.length, parameterHolder, this.serverPrepareResult, this.results);
                                        if (!this.hasLongData(parameterHolder)) {
                                            this.serverPrepareResult = null;
                                        }
                                    } else {
                                        this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, parameterHolder);
                                    }
                                    this.parameterCount = parameterCountReal;
                                    this.originalSql = curString;
                                }
                                catch (SQLException queryException) {
                                    if (!this.options.continueBatchOnError) throw queryException;
                                    if (exception != null) break block44;
                                    exception = queryException;
                                }
                                break block44;
                            }
                            if (this.options.useServerPrepStmts && !this.protocol.getAutocommit() && this.protocol.isOracleMode() && this.options.useArrayBinding) break block50;
                            break block51;
                        }
                        executeBatchByArrayBinding = this.protocol.supportStmtPrepareExecute();
                        ParameterHolder[] preParameterHolder = null;
                        int startIndex = 0;
                        int endIndex = 0;
                        int counter = 0;
                        while (true) {
                            ParameterHolder[] curParameterHolder;
                            block53: {
                                block54: {
                                    block52: {
                                        if (counter >= queryParameterSize) break block52;
                                        curParameterHolder = this.parametersList.get(counter);
                                        endIndex = counter;
                                        if (counter == 0) break block53;
                                        break block54;
                                    }
                                    if (startIndex == ++endIndex || (exceptionRet = this.executeArrayBinding(startIndex, endIndex, endIndex - startIndex)) == null) break block44;
                                    exception = exceptionRet;
                                    break block44;
                                }
                                for (int i = 0; i < curParameterHolder.length; ++i) {
                                    if (curParameterHolder[i].getColumnType().getType() == preParameterHolder[i].getColumnType().getType()) continue;
                                    exceptionRet = this.executeArrayBinding(startIndex, endIndex, endIndex - startIndex);
                                    if (exceptionRet != null) {
                                        exception = exceptionRet;
                                    }
                                    startIndex = counter;
                                    break;
                                }
                            }
                            preParameterHolder = curParameterHolder;
                            ++counter;
                        }
                    }
                    for (int counter = 0; counter < queryParameterSize; ++counter) {
                        ParameterHolder[] parameterHolder = this.parametersList.get(counter);
                        try {
                            if (this.queryTimeout > 0) {
                                this.protocol.stopIfInterrupted();
                            }
                            if (this.serverPrepareResult != null) {
                                this.serverPrepareResult.resetParameterTypeHeader();
                            }
                            if (this.protocol.supportStmtPrepareExecute()) {
                                this.serverPrepareResult = this.protocol.executePreparedQuery(parameterCountReal, parameterHolder, this.serverPrepareResult, this.results);
                                continue;
                            }
                            this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, parameterHolder);
                            continue;
                        }
                        catch (SQLException queryException) {
                            if (!this.options.continueBatchOnError) throw queryException;
                            if (exception != null) continue;
                            exception = queryException;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                this.protocol.resetChecksum();
                this.results.commandEnd();
            }
            return;
        }
        catch (SQLException initialSqlEx) {
            throw this.executeBatchExceptionEpilogue(initialSqlEx, queryParameterSize, executeBatchByArrayBinding);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    private void executeQueryPrologue(ServerPrepareResult serverPrepareResult) throws SQLException {
        this.executing = true;
        if (this.isClosed()) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("execute() is called on closed statement");
        }
        this.protocol.prologProxy(serverPrepareResult, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute() && this.results != null && this.results.getResultSet() != null) {
            return this.results.getResultSet();
        }
        if (this.results.isReturning()) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (this.execute()) {
            return 0L;
        }
        if (this.results.isReturning() && this.results.getResultSet() != null) {
            return this.results.getResultSet().getProcessedRows();
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 0;
        }
        if (this.results.isReturning() && this.results.getResultSet() != null) {
            return (int)this.results.getResultSet().getProcessedRows();
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.protocol.supportStmtPrepareExecute()) {
            return this.prepareExecuteInternal(this.getFetchSize());
        }
        return this.executeInternal(this.getFetchSize());
    }

    @Override
    protected boolean executeInternal(int fetchSize) throws SQLException {
        this.validParameters();
        this.lock.lock();
        try {
            this.executeQueryPrologue(this.serverPrepareResult);
            if (this.queryTimeout != 0 && this.options.enableQueryTimeouts) {
                this.setTimerTask(false);
            }
            ParameterHolder[] parameterHolders = this.currentParameterHolder.values().toArray(new ParameterHolder[0]);
            this.results = new Results(this, fetchSize, false, 1, true, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), this.actualSql, parameterHolders);
            this.protocol.setChecksum(this.checksum);
            this.serverPrepareResult.resetParameterTypeHeader();
            this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, parameterHolders);
            this.protocol.resetChecksum();
            this.results.commandEnd();
            if (this.results.getCallableResultSet() != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    protected boolean prepareExecuteInternal(int fetchSize) throws SQLException {
        this.validParameters();
        this.lock.lock();
        try {
            if (this.sqlType == 1) {
                int n = this.iterationCount = this.isFetchSizeSet ? fetchSize : 10;
                if (this.resultSetScrollType != 1003) {
                    this.executeMode |= 8;
                }
            } else {
                this.iterationCount = 1;
            }
            this.calculateCheckSum(this.actualSql);
            this.protocol.setComStmtPrepareExecuteField(this.iterationCount, this.executeMode, this.checksum);
            if (this.parameterCount > 0) {
                this.sendTypesToServer = true;
            }
            this.executeQueryPrologue(this.serverPrepareResult);
            if (this.queryTimeout != 0 && this.options.enableQueryTimeouts) {
                this.setTimerTask(false);
            }
            ParameterHolder[] parameterHolders = this.currentParameterHolder.values().toArray(new ParameterHolder[0]);
            this.results = new Results(this, fetchSize, false, 1, true, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), this.actualSql, parameterHolders);
            if (this.serverPrepareResult != null) {
                this.serverPrepareResult.resetParameterTypeHeader();
                this.results.setStatementId(this.serverPrepareResult.getStatementId());
            }
            this.serverPrepareResult = this.protocol.executePreparedQuery(this.parameterCount, parameterHolders, this.serverPrepareResult, this.results);
            if (this.resultSetMetaData == null) {
                this.setMetaFromResult();
            }
            this.protocol.resetChecksum();
            this.results.commandEnd();
            if (this.results.getCallableResultSet() != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = !this.results.isReturning() && this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            if (this.addRowid) {
                this.degradeResultSetType();
                this.addRowid = false;
                this.actualSql = this.originalSql;
                boolean bl = this.prepareExecuteInternal(fetchSize);
                return bl;
            }
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnDefinition[] cursorFetch(int cursorId, int fetchSize) throws SQLException {
        this.lock.lock();
        try {
            ColumnDefinition[] ci = this.protocol.fetchRowViaCursor(cursorId, fetchSize, this.results);
            this.results.commandEnd();
            ColumnDefinition[] columnDefinitionArray = ci;
            return columnDefinitionArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeCursor(int cursorId) throws SQLException {
        this.lock.lock();
        try {
            this.protocol.forceReleasePrepareStatement(cursorId);
            this.results.commandEnd();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnDefinition[] cursorFetchForOracle(int cursorId, int numRows, byte offsetType, int offset) throws SQLException {
        this.lock.lock();
        try {
            ColumnDefinition[] ci = this.protocol.fetchRowViaCursorForOracle(cursorId, numRows, offsetType, offset, this.results);
            this.results.commandEnd();
            ColumnDefinition[] columnDefinitionArray = ci;
            return columnDefinitionArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        this.realClose(true, true);
    }

    @Override
    public void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        if (!this.released && this.protocol != null && this.serverPrepareResult != null) {
            try {
                this.serverPrepareResult.getUnProxiedProtocol().releasePrepareStatement(this.serverPrepareResult);
                this.released = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.realClose(calledExplicitly, closeOpenResults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sql : '" + this.actualSql + "'");
        if (this.parameterCount > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameterCount; ++i) {
                ParameterHolder holder = this.currentParameterHolder.get(i);
                if (holder == null) {
                    sb.append("null");
                } else {
                    sb.append(holder.toString());
                }
                if (i == this.parameterCount - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public long getServerThreadId() {
        return this.serverPrepareResult.getUnProxiedProtocol().getServerThreadId();
    }

    public ResultSet getReturnResultSet() throws SQLException {
        this.checkClose();
        if (this.returnParamCount != 0 && this.returnParams != null) {
            return this.results != null && this.results.isReturning() ? this.results.getResultSet() : null;
        }
        throw new SQLException("Statement handle not executed");
    }
}

