/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.Datum;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TIMESTAMP
extends Datum
implements Serializable {
    public TIMESTAMP() {
        super(DataTypeUtilities.initTimestamp());
    }

    public TIMESTAMP(byte[] bytes) {
        super(bytes);
    }

    public TIMESTAMP(Time time) {
        super(DataTypeUtilities.TIMESTMAPToBytes(time));
    }

    public TIMESTAMP(Date date) {
        super(DataTypeUtilities.TIMESTMAPToBytes(date));
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(DataTypeUtilities.TIMESTAMPToBytes(timestamp));
    }

    public TIMESTAMP(Timestamp timestamp, Calendar calendar) {
        super(DataTypeUtilities.TIMESTAMPToBytes(timestamp, calendar));
    }

    public TIMESTAMP(String str) {
        super(TIMESTAMP.toBytes(str));
    }

    public static Timestamp toTimestamp(byte[] bytes) throws SQLException {
        return DataTypeUtilities.innerToTimestamp(bytes, null);
    }

    public static Timestamp toTimestamp(byte[] bytes, Calendar calendar) throws SQLException {
        return DataTypeUtilities.innerToTimestamp(bytes, calendar);
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    @Override
    public Timestamp timestampValue(Calendar calendar) throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes(), calendar);
    }

    public static String toString(byte[] bytes) {
        return DataTypeUtilities.TIMESTMAPBytesToString(bytes);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(String str) {
        return DataTypeUtilities.TIMESTAMPToBytes(Timestamp.valueOf(str));
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int len) {
        Timestamp[] timestamps = new Timestamp[len];
        return timestamps;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Date dateValue() throws SQLException {
        return DataTypeUtilities.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return DataTypeUtilities.toTime(this.getBytes());
    }

    private boolean isValid() {
        byte[] bytes = this.getBytes();
        if (bytes.length < DataTypeUtilities.TIMESTAMP_SIZE) {
            return false;
        }
        return DataTypeUtilities.isValid((bytes[0] & 0xFF) * 100 + (bytes[1] & 0xFF), bytes[2] & 0xFF, bytes[3] & 0xFF, bytes[4] & 0xFF, bytes[5] & 0xFF, bytes[6] & 0xFF);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }
}

