/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Buffer {
    public byte[] buf;
    public int position;
    public int limit;
    static final long NULL_LENGTH = -1L;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Buffer(byte[] buf, int limit) {
        this.buf = buf;
        this.limit = limit;
    }

    public Buffer(byte[] buf) {
        this.buf = buf;
        this.limit = this.buf.length;
    }

    public Buffer() {
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public void checkRemainder(long need) throws IOException {
        if ((long)this.remaining() < need) {
            throw new IOException("Buffer will overflow: need " + need + " bytes, but remain " + this.remaining() + " bytes.");
        }
    }

    public String readStringNullEnd(Charset charset) {
        int initialPosition = this.position;
        int cnt = 0;
        while (this.remaining() > 0 && this.buf[this.position++] != 0) {
            ++cnt;
        }
        return new String(this.buf, initialPosition, cnt, charset);
    }

    public byte[] readBytesNullEnd() {
        int initialPosition = this.position;
        int cnt = 0;
        while (this.remaining() > 0 && this.buf[this.position++] != 0) {
            ++cnt;
        }
        byte[] tmpArr = new byte[cnt];
        System.arraycopy(this.buf, initialPosition, tmpArr, 0, cnt);
        return tmpArr;
    }

    public String readString(int numberOfBytes) {
        this.position += numberOfBytes;
        return new String(this.buf, this.position - numberOfBytes, numberOfBytes);
    }

    public short readShort() {
        return (short)((this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8));
    }

    public int readInt2() {
        return this.buf[this.position++] & 0xFF | (this.buf[this.position++] & 0xFF) << 8;
    }

    public int readIntV1() {
        byte[] b = this.buf;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
    }

    public int readInt3() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16);
    }

    public int read24bitword() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16);
    }

    public int readInt4() {
        return this.buf[this.position++] & 0xFF | ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16) | (this.buf[this.position++] & 0xFF) << 24;
    }

    public int readInt() {
        return (this.buf[this.position++] & 0xFF) + ((this.buf[this.position++] & 0xFF) << 8) + ((this.buf[this.position++] & 0xFF) << 16) + ((this.buf[this.position++] & 0xFF) << 24);
    }

    public int readnBytes() {
        int sw = this.buf[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                return this.buf[this.position++] & 0xFF;
            }
            case 2: {
                return this.readInt4();
            }
            case 3: {
                return this.readInt3();
            }
            case 4: {
                return (int)this.readLong4();
            }
        }
        return 255;
    }

    public long readLong4() {
        byte[] b = this.buf;
        return (long)b[this.position++] & 0xFFL | ((long)b[this.position++] & 0xFFL) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24;
    }

    public long readLongV1() {
        byte[] b = this.buf;
        return (long)b[this.position++] & 0xFFL | ((long)b[this.position++] & 0xFFL) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24;
    }

    public long readLong8() {
        return (long)(this.buf[this.position++] & 0xFF) + ((long)(this.buf[this.position++] & 0xFF) << 8) + ((long)(this.buf[this.position++] & 0xFF) << 16) + ((long)(this.buf[this.position++] & 0xFF) << 24) + ((long)(this.buf[this.position++] & 0xFF) << 32) + ((long)(this.buf[this.position++] & 0xFF) << 40) + ((long)(this.buf[this.position++] & 0xFF) << 48) + ((long)(this.buf[this.position++] & 0xFF) << 56);
    }

    public long readLongLongV1() {
        byte[] b = this.buf;
        return (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
    }

    public long readLong() {
        return (long)(this.buf[this.position++] & 0xFF) + ((long)(this.buf[this.position++] & 0xFF) << 8) + ((long)(this.buf[this.position++] & 0xFF) << 16) + ((long)(this.buf[this.position++] & 0xFF) << 24) + ((long)(this.buf[this.position++] & 0xFF) << 32) + ((long)(this.buf[this.position++] & 0xFF) << 40) + ((long)(this.buf[this.position++] & 0xFF) << 48) + ((long)(this.buf[this.position++] & 0xFF) << 56);
    }

    public byte readByte() {
        return this.buf[this.position++];
    }

    public byte[] readLenByteArray(int offset) {
        long len = this.readFieldLength();
        if (len == -1L) {
            return null;
        }
        if (len == 0L) {
            return EMPTY_BYTE_ARRAY;
        }
        this.position += offset;
        return this.readBytes((int)len);
    }

    public byte getByte() {
        return this.buf[this.position];
    }

    public void skipByte() {
        ++this.position;
    }

    public byte getByteAt(int position) {
        return this.buf[position];
    }

    public byte[] readBytes(int numberOfBytes) {
        byte[] tmpArr = new byte[numberOfBytes];
        System.arraycopy(this.buf, this.position, tmpArr, 0, numberOfBytes);
        this.position += numberOfBytes;
        return tmpArr;
    }

    public byte[] readRawBytes(int numberOfBytes) {
        byte[] tmpArr = new byte[numberOfBytes];
        System.arraycopy(this.buf, this.position, tmpArr, 0, numberOfBytes);
        this.position += numberOfBytes;
        return tmpArr;
    }

    public byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.buf, this.position, b, 0, len);
        return b;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] dest = new byte[len];
        System.arraycopy(this.buf, offset, dest, 0, len);
        return dest;
    }

    public void skipBytes(int bytesToSkip) {
        this.position += bytesToSkip;
    }

    public byte[] getLengthEncodedBytes() {
        int length = (int)this.getLengthEncodedNumeric();
        if (length == -1) {
            return null;
        }
        byte[] tmpBuf = new byte[length];
        System.arraycopy(this.buf, this.position, tmpBuf, 0, length);
        this.position += length;
        return tmpBuf;
    }

    public void skipLengthEncodedBytes() {
        long length = this.getLengthEncodedNumeric();
        if (length == -1L) {
            return;
        }
        this.position = (int)((long)this.position + length);
    }

    public long getLengthEncodedNumeric() {
        int type = this.buf[this.position++] & 0xFF;
        switch (type) {
            case 251: {
                return -1L;
            }
            case 252: {
                return 0xFFFF & this.readShort();
            }
            case 253: {
                return 0xFFFFFF & this.readInt3();
            }
            case 254: {
                return this.readLong8();
            }
        }
        return type;
    }

    public void skipLengthEncodedNumeric() {
        int type = this.buf[this.position++] & 0xFF;
        switch (type) {
            case 252: {
                this.position += 2;
                return;
            }
            case 253: {
                this.position += 3;
                return;
            }
            case 254: {
                this.position += 8;
                return;
            }
        }
    }

    public Buffer getLengthEncodedBuffer() {
        return new Buffer(this.getLengthEncodedBytes());
    }

    public String readStringLengthEncoded(Charset charset) {
        int length = (int)this.getLengthEncodedNumeric();
        String string = new String(this.buf, this.position, length, charset);
        this.position += length;
        return string;
    }

    public int fastSkipLenString() {
        long len = this.readFieldLength();
        this.position = (int)((long)this.position + len);
        return (int)len;
    }

    public final long readFieldLength() {
        int sw = this.buf[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return -1L;
            }
            case 252: {
                return this.readInt2();
            }
            case 253: {
                return this.readInt3();
            }
            case 254: {
                return this.readLong8();
            }
        }
        return sw;
    }

    public void writeByte(byte b) {
        while (this.remaining() < 1) {
            this.grow();
        }
        this.buf[this.position++] = b;
    }

    public void writeBytes(byte[] bytes, int off, int length) {
        while (this.remaining() < length) {
            this.grow();
        }
        System.arraycopy(bytes, off, this.buf, this.position, length);
        this.position += length;
    }

    public void writeBytes(byte header, byte[] bytes) {
        int length = bytes.length;
        while (this.remaining() < length + 10) {
            this.grow();
        }
        this.writeLength(length + 1);
        this.buf[this.position++] = header;
        System.arraycopy(bytes, 0, this.buf, this.position, length);
        this.position += length;
    }

    public void writeShort(short num) {
        while (this.remaining() < 2) {
            this.grow();
        }
        this.buf[this.position++] = (byte)num;
        this.buf[this.position++] = (byte)(num >>> 8);
    }

    public void writeShortV2(short num) {
        while (this.remaining() < 2) {
            this.grow();
        }
        this.buf[this.position++] = (byte)(num >>> 8);
        this.buf[this.position++] = (byte)num;
    }

    public void writeLongInt(int num) {
        while (this.remaining() < 3) {
            this.grow();
        }
        this.buf[this.position++] = (byte)num;
        this.buf[this.position++] = (byte)(num >>> 8);
        this.buf[this.position++] = (byte)(num >>> 16);
    }

    public void writeInt(int num) {
        while (this.remaining() < 4) {
            this.grow();
        }
        this.buf[this.position++] = (byte)num;
        this.buf[this.position++] = (byte)(num >>> 8);
        this.buf[this.position++] = (byte)(num >>> 16);
        this.buf[this.position++] = (byte)(num >>> 24);
    }

    public void writeIntV2(int num) {
        while (this.remaining() < 4) {
            this.grow();
        }
        this.buf[this.position++] = (byte)(num >>> 24);
        this.buf[this.position++] = (byte)(num >>> 16);
        this.buf[this.position++] = (byte)(num >>> 8);
        this.buf[this.position++] = (byte)num;
    }

    public void writeNBytes(long num, int n) {
        while (this.remaining() < n) {
            this.grow();
        }
        for (int i = 0; i < n; ++i) {
            this.buf[this.position++] = (byte)(num >>> 8 * i);
        }
    }

    public void writeLongFromLowToHigh(long num) {
        while (this.remaining() < 8) {
            this.grow();
        }
        this.buf[this.position++] = (byte)num;
        this.buf[this.position++] = (byte)(num >>> 8);
        this.buf[this.position++] = (byte)(num >>> 16);
        this.buf[this.position++] = (byte)(num >>> 24);
        this.buf[this.position++] = (byte)(num >>> 32);
        this.buf[this.position++] = (byte)(num >>> 40);
        this.buf[this.position++] = (byte)(num >>> 48);
        this.buf[this.position++] = (byte)(num >>> 56);
    }

    public void writeLongFromHighToLow(long num) {
        while (this.remaining() < 8) {
            this.grow();
        }
        this.buf[this.position++] = (byte)(num >>> 56 & 0xFFL);
        this.buf[this.position++] = (byte)(num >>> 48 & 0xFFL);
        this.buf[this.position++] = (byte)(num >>> 40 & 0xFFL);
        this.buf[this.position++] = (byte)(num >>> 32 & 0xFFL);
        this.buf[this.position++] = (byte)(num >>> 24 & 0xFFL);
        this.buf[this.position++] = (byte)(num >>> 16 & 0xFFL);
        this.buf[this.position++] = (byte)(num >>> 8 & 0xFFL);
        this.buf[this.position++] = (byte)(num & 0xFFL);
    }

    public void writeString(String str) {
        int length = str.length();
        while (this.remaining() < length) {
            this.grow();
        }
        System.arraycopy(str.getBytes(StandardCharsets.UTF_8), 0, this.buf, this.position, length);
        this.position += length;
    }

    public void writeStringLength(String value, Charset charset) {
        byte[] bytes = value.getBytes(charset);
        int length = bytes.length;
        while (this.remaining() < length + 9) {
            this.grow();
        }
        this.writeLength(length);
        System.arraycopy(bytes, 0, this.buf, this.position, length);
        this.position += length;
    }

    public void writeStringLength(byte[] bytes) {
        int length = bytes.length;
        while (this.remaining() < length + 9) {
            this.grow();
        }
        this.writeLength(length);
        System.arraycopy(bytes, 0, this.buf, this.position, length);
        this.position += length;
    }

    public void writeStringSmallLength(byte[] value) {
        int length = value.length;
        while (this.remaining() < length + 1) {
            this.grow();
        }
        this.buf[this.position++] = (byte)length;
        System.arraycopy(value, 0, this.buf, this.position, length);
        this.position += length;
    }

    public void writeLength(long length) {
        if (length < 251L) {
            this.buf[this.position++] = (byte)length;
        } else if (length < 65536L) {
            this.buf[this.position++] = -4;
            this.buf[this.position++] = (byte)length;
            this.buf[this.position++] = (byte)(length >>> 8);
        } else if (length < 0x1000000L) {
            this.buf[this.position++] = -3;
            this.buf[this.position++] = (byte)length;
            this.buf[this.position++] = (byte)(length >>> 8);
            this.buf[this.position++] = (byte)(length >>> 16);
        } else {
            this.buf[this.position++] = -2;
            this.buf[this.position++] = (byte)length;
            this.buf[this.position++] = (byte)(length >>> 8);
            this.buf[this.position++] = (byte)(length >>> 16);
            this.buf[this.position++] = (byte)(length >>> 24);
            this.buf[this.position++] = (byte)(length >>> 32);
            this.buf[this.position++] = (byte)(length >>> 40);
            this.buf[this.position++] = (byte)(length >>> 48);
            this.buf[this.position++] = (byte)(length >>> 54);
        }
    }

    private void grow() {
        int newCapacity = this.buf.length + (this.buf.length >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
        this.limit = newCapacity;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getLimit() {
        return this.limit;
    }

    public byte[] getByteBuffer() {
        return this.buf;
    }
}

