/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.ObArray;
import com.oceanbase.jdbc.extend.datatype.ComplexUtil;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.sql.SQLException;

public class OBArrayParameter
implements Cloneable,
ParameterHolder {
    ObArray arrayValue;
    Options options;

    public OBArrayParameter(ObArray arrayImpl, Options options) {
        this.arrayValue = arrayImpl;
        this.options = options;
    }

    public void storeArrayTypeInfo(PacketOutputStream packet) throws IOException, SQLException {
        ObArray array = this.arrayValue;
        packet.writeFieldLength(0L);
        packet.writeFieldLength(0L);
        packet.writeFieldLength(array.getComplexType().getVersion());
        short elementType = ComplexUtil.getMysqlType(array.getBaseType()).getType();
        packet.writeBytes((byte)elementType, 1);
        if (elementType >= ColumnType.COMPLEX.getType() && elementType <= ColumnType.STRUCT.getType()) {
            byte[] tmp = array.getComplexType().getAttrType(0).getSchemaName().getBytes();
            packet.writeFieldLength(tmp.length);
            packet.write(tmp);
            tmp = array.getComplexType().getAttrType(0).getTypeName().getBytes();
            packet.writeFieldLength(tmp.length);
            packet.write(tmp);
            packet.writeFieldLength(tmp.length);
        }
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        try {
            pos.writeFieldLength(this.arrayValue.getAttrCount());
            int nullCount = (this.arrayValue.getAttrCount() + 7) / 8;
            int nullBitsPosition = pos.getPosition();
            for (int i = 0; i < nullCount; ++i) {
                pos.writeBytes((byte)0, 1);
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i = 0; i < this.arrayValue.getAttrCount(); ++i) {
                if (null != this.arrayValue.getAttrData(i)) {
                    ComplexUtil.storeComplexAttrData(pos, this.arrayValue.getComplexType().getAttrType(0), this.arrayValue.getAttrData(i), this.options);
                    continue;
                }
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
            }
            int endPosition = pos.getPosition();
            pos.setPosition(nullBitsPosition);
            pos.write(nullBitsBuffer);
            pos.setPosition(endPosition);
        }
        catch (Exception e) {
            throw new IOException("storeComplexAttrData exception");
        }
    }

    @Override
    public int getApproximateTextProtocolLength() throws IOException {
        return 0;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.COMPLEX;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

