/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.ObStruct;
import com.oceanbase.jdbc.extend.datatype.ComplexUtil;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;

public class OBStructParameter
implements Cloneable,
ParameterHolder {
    ObStruct structValue;
    Options options;

    public void storeStructTypeInfo(PacketOutputStream packet) throws IOException {
        ObStruct struct = this.structValue;
        byte[] tmp = struct.getComplexType().getSchemaName().getBytes();
        packet.writeFieldLength(tmp.length);
        packet.write(tmp);
        tmp = struct.getComplexType().getTypeName().getBytes();
        packet.writeFieldLength(tmp.length);
        packet.write(tmp);
        packet.writeFieldLength(struct.getComplexType().getVersion());
    }

    public OBStructParameter(ObStruct structImpl, Options options) {
        this.structValue = structImpl;
        this.options = options;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        try {
            int nullCount = (this.structValue.getAttrCount() + 7) / 8;
            int nullBitsPosition = pos.getPosition();
            for (int i = 0; i < nullCount; ++i) {
                pos.writeBytes((byte)0, 1);
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i = 0; i < this.structValue.getAttrCount(); ++i) {
                if (null != this.structValue.getAttrData(i)) {
                    ComplexUtil.storeComplexAttrData(pos, this.structValue.getComplexType().getAttrType(i), this.structValue.getAttrData(i), this.options);
                    continue;
                }
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
            }
            int endPosition = pos.getPosition();
            pos.setPosition(nullBitsPosition);
            pos.write(nullBitsBuffer);
            pos.setPosition(endPosition);
        }
        catch (Exception e) {
            throw new IOException("storeComplexAttrData exception");
        }
    }

    @Override
    public int getApproximateTextProtocolLength() throws IOException {
        return 0;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.COMPLEX;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

