/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.auth;

import com.redhat.cloud.common.auth.XRhIdentity;
import java.util.Base64;
import java.util.Optional;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;
import javax.ws.rs.core.HttpHeaders;

public abstract class HeaderHelper {
    private static Jsonb jsonb = JsonbBuilder.create();

    public static Optional<XRhIdentity> getRhIdFromHeader(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return Optional.empty();
        }
        String headerString = httpHeaders.getHeaderString("x-rh-identity");
        if (headerString == null) {
            return Optional.empty();
        }
        return HeaderHelper.getRhIdFromString(headerString);
    }

    public static Optional<XRhIdentity> getRhIdFromString(String xRhIdHeader) {
        XRhIdentity rhIdentity;
        try {
            String json_string = new String(Base64.getDecoder().decode(xRhIdHeader));
            rhIdentity = (XRhIdentity)jsonb.fromJson(json_string, XRhIdentity.class);
        }
        catch (JsonbException jbe) {
            return Optional.empty();
        }
        return Optional.ofNullable(rhIdentity);
    }
}

