/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.auth;

import com.redhat.cloud.common.auth.HeaderHelper;
import com.redhat.cloud.common.auth.RhIdPrincipal;
import com.redhat.cloud.common.auth.RhIdPrincipalProducer;
import com.redhat.cloud.common.auth.RhIdSecurityContext;
import com.redhat.cloud.common.auth.XRhIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@PreMatching
@Provider
public class IncomingRequestFilter
implements ContainerRequestFilter {
    private final Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private final boolean logFine = this.log.isLoggable(Level.FINE);
    @Inject
    RhIdPrincipalProducer producer;
    volatile CurrentVertxRequest currentVertxRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        RoutingContext routingContext = this.request().getCurrent();
        String normalisedPath = routingContext.normalisedPath();
        if (normalisedPath.endsWith("openapi.json")) {
            return;
        }
        String xrhid_header = requestContext.getHeaderString("x-rh-identity");
        if (xrhid_header == null || xrhid_header.isEmpty()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            if (this.logFine) {
                this.log.fine("No x-rh-identity header passed");
            }
            return;
        }
        Optional<XRhIdentity> xrhid = HeaderHelper.getRhIdFromString(xrhid_header);
        if (xrhid.isPresent()) {
            XRhIdentity rhIdentity = xrhid.get();
            if (rhIdentity.getUsername() == null || rhIdentity.getUsername().isEmpty() || rhIdentity.identity.accountNumber == null || rhIdentity.identity.accountNumber.isEmpty()) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                if (this.logFine) {
                    this.log.fine("X-rh-identity header has no user or account");
                }
                return;
            }
            RhIdPrincipal rhPrincipal = new RhIdPrincipal(rhIdentity.getUsername(), rhIdentity.identity.accountNumber);
            rhPrincipal.setRawRhIdHeader(xrhid_header);
            routingContext.put("x-rh-account", (Object)rhIdentity.identity.accountNumber);
            RhIdSecurityContext sctx = new RhIdSecurityContext(rhIdentity, rhPrincipal);
            requestContext.setSecurityContext((SecurityContext)sctx);
            this.producer.setPrincipal(rhPrincipal);
        } else {
            if (this.logFine) {
                this.log.fine("X-rh-identity header could not be parsed");
            }
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    CurrentVertxRequest request() {
        if (this.currentVertxRequest == null) {
            this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        }
        return this.currentVertxRequest;
    }
}

