/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.auth;

import com.redhat.cloud.common.auth.RbacRaw;
import com.redhat.cloud.common.auth.RbacServer;
import com.redhat.cloud.common.auth.RhIdPrincipal;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.quarkus.cache.CacheResult;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@Provider
@Priority(value=3001)
public class RbacFilter
implements ContainerRequestFilter {
    private final Logger log = Logger.getLogger("RbacFilter");
    @Inject
    Tracer tracer;
    @Inject
    @RestClient
    RbacServer rbac;
    @Inject
    RhIdPrincipal user;
    @ConfigProperty(name="warn.rbac.slow", defaultValue="true")
    Instance<Boolean> warnSlowRbac;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        RbacRaw result;
        long t1 = System.currentTimeMillis();
        try (Scope ignored = this.tracer.buildSpan("getRBac").startActive(true);){
            result = this.getRbacInfo(this.user.getRawRhIdHeader());
        }
        catch (Throwable e) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            return;
        }
        finally {
            long t2 = System.currentTimeMillis();
            if (((Boolean)this.warnSlowRbac.get()).booleanValue() && t2 - t1 > 500L) {
                this.log.warning("Call to RBAC took " + (t2 - t1) + "ms");
            }
        }
        this.user.setRbac(result.canReadAll(), result.canWriteAll());
        RhIdPrincipal userPrincipal = (RhIdPrincipal)requestContext.getSecurityContext().getUserPrincipal();
        userPrincipal.setRbac(result.canReadAll(), result.canWriteAll());
    }

    @CacheResult(cacheName="rbac-cache")
    RbacRaw getRbacInfo(String xrhidHeader) {
        RbacRaw result = this.rbac.getRbacInfo("policies", xrhidHeader);
        return result;
    }
}

