/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.auth;

import java.util.List;
import java.util.Map;

public class RbacRaw {
    public Map<String, String> links;
    public Map<String, Integer> meta;
    public List<Map<String, Object>> data;

    public boolean canRead(String path) {
        return this.findPermission(path, "read");
    }

    public boolean canWrite(String path) {
        return this.findPermission(path, "write");
    }

    public boolean canReadAll() {
        return this.canRead("*");
    }

    public boolean canWriteAll() {
        return this.canWrite("*");
    }

    public boolean canDo(String path, String permission) {
        return this.findPermission(path, permission);
    }

    private boolean findPermission(String path, String what) {
        if (this.data == null || this.data.size() == 0) {
            return false;
        }
        for (Map<String, Object> permissionEntry : this.data) {
            String[] fields = this.getPermissionFields(permissionEntry);
            if (!fields[1].equals(path) || !fields[2].equals(what) && !fields[2].equals("*")) continue;
            return true;
        }
        return false;
    }

    private String[] getPermissionFields(Map<String, Object> map) {
        String perms = (String)map.get("permission");
        return perms.split(":");
    }
}

