/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.pager;

import com.redhat.cloud.common.pager.Pager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.validation.constraints.NotNull;

public class Page<T>
implements List<T> {
    private List<T> wrapped;
    private Pager pager;
    private long totalCount;

    public Page(List<T> wrapped, Pager pager, long totalCount) {
        this.wrapped = wrapped;
        this.pager = pager;
        this.totalCount = totalCount;
    }

    public Pager getPager() {
        return this.pager;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        final Iterator<T> it = this.wrapped.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(T1[] t1s) {
        return this.wrapped.toArray(t1s);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    @NotNull
    public boolean containsAll(Collection<?> collection) {
        return this.wrapped.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public T get(int i) {
        return this.wrapped.get(i);
    }

    @Override
    public T set(int i, T t) {
        throw new UnsupportedOperationException("set");
    }

    @Override
    public void add(int i, T t) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public int indexOf(Object o) {
        return this.wrapped.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrapped.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new WrapperListIterator<T>(this.wrapped.listIterator());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int i) {
        return new WrapperListIterator<T>(this.wrapped.listIterator(i));
    }

    @Override
    @NotNull
    public List<T> subList(int i, int j) {
        return new Page<T>(this.wrapped.subList(i, j), this.pager, this.totalCount);
    }

    class WrapperListIterator<T>
    implements ListIterator<T> {
        private ListIterator<T> wrapped;

        private WrapperListIterator(ListIterator<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public T next() {
            return this.wrapped.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.wrapped.hasPrevious();
        }

        @Override
        public T previous() {
            return this.wrapped.previous();
        }

        @Override
        public int nextIndex() {
            return this.wrapped.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wrapped.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException("set");
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException("add");
        }
    }
}

