/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.cloud.common.pager;

import com.redhat.cloud.common.filter.Filter;
import com.redhat.cloud.common.pager.Sort;
import io.reactivex.annotations.Nullable;

public class Pager {
    public static final int NO_LIMIT = -1;
    private final int offset;
    private final int limit;
    @Nullable
    private final Sort sort;
    private final Filter filter;

    public Pager(int offset, int limit, Filter filter, Sort sort) {
        this.offset = offset;
        this.limit = limit;
        this.filter = filter;
        this.sort = sort;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Filter getFilter() {
        return (Filter)this.filter.clone();
    }

    public Sort getSort() {
        return this.sort;
    }

    public static PagerBuilder builder() {
        return new PagerBuilder();
    }

    public static class PagerBuilder {
        private int offset = 0;
        private int limit = 50;
        private Sort sort = Sort.by(new String[0]);
        private Filter filter = new Filter();

        private PagerBuilder() {
        }

        public PagerBuilder page(int offset) {
            this.offset = offset;
            return this;
        }

        public PagerBuilder itemsPerPage(int limit) {
            this.limit = limit;
            return this;
        }

        public PagerBuilder addSort(String column, Sort.Direction direction) {
            this.sort.and(column, direction);
            return this;
        }

        public PagerBuilder filter(String column, Filter.Operator operator, String value) {
            Object transformedValue = value;
            if (operator.equals((Object)Filter.Operator.BOOLEAN_IS)) {
                transformedValue = Boolean.valueOf(value);
            }
            this.filter.and(column, operator, transformedValue);
            return this;
        }

        public Pager build() {
            return new Pager(this.offset, this.limit, (Filter)this.filter.clone(), this.sort);
        }
    }
}

