/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.ShimBundle;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;

class ShimStorage {
    private final File configDir;

    ShimStorage(Map<String, String> props, Logger logger) {
        String configArea = props.get("osgi.configuration.area");
        if (configArea == null) {
            logger.warn("Recommend setting osgi.configuration.area to a directory, getDataFile will return null");
            this.configDir = null;
        } else {
            this.configDir = new File(configArea);
        }
    }

    File getDataFileBundle(ShimBundle bundle, @Nullable String filename) {
        if (this.configDir == null) {
            return null;
        }
        File dir = new File(this.configDir, bundle.getSymbolicName() + "/" + bundle.getBundleId() + "/data");
        dir.mkdirs();
        if (filename == null) {
            return dir;
        }
        return new File(dir, filename);
    }
}

