/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheInternalError;
import org.cache2k.core.InternalCache;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.core.spi.CacheManagerLifeCycleListener;
import org.cache2k.core.util.Log;
import org.cache2k.spi.Cache2kCoreProvider;

public class CacheManagerImpl
extends CacheManager {
    public static final Cache2kCoreProvider PROVIDER = CacheManager.PROVIDER;
    private static final Iterable<CacheLifeCycleListener> cacheLifeCycleListeners = CacheManagerImpl.constructAllServiceImplementations(CacheLifeCycleListener.class);
    private static final Iterable<CacheManagerLifeCycleListener> cacheManagerLifeCycleListeners = CacheManagerImpl.constructAllServiceImplementations(CacheManagerLifeCycleListener.class);
    private Map<String, StackTrace> name2CreationStackTrace = null;
    private final Object lock = new Object();
    private Log log;
    private String name;
    private Map<String, InternalCache> cacheNames = new HashMap<String, InternalCache>();
    private final Properties properties = new Properties();
    private ClassLoader classLoader;
    private boolean defaultManager;
    private Cache2kCoreProviderImpl provider;
    private boolean closing;

    private static <S> Iterable<S> constructAllServiceImplementations(Class<S> _service) {
        ClassLoader cl = CacheManagerImpl.class.getClassLoader();
        ArrayList<S> li = new ArrayList<S>();
        for (S l : ServiceLoader.load(_service, cl)) {
            li.add(l);
        }
        final Object[] a = (Object[])Array.newInstance(_service, li.size());
        li.toArray(a);
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                return new Iterator<S>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < a.length;
                    }

                    @Override
                    public S next() {
                        return a[this.pos++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public CacheManagerImpl(Cache2kCoreProviderImpl _provider, ClassLoader cl, String _name, boolean _default) {
        this.provider = _provider;
        this.defaultManager = _default;
        this.classLoader = cl;
        this.name = _name;
        this.log = Log.getLog(CacheManager.class.getName() + ':' + this.name);
        boolean _traceCacheCreation = this.log.isDebugEnabled();
        boolean _assertionsEnabled = false;
        _traceCacheCreation |= _assertionsEnabled;
        for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
            lc.managerCreated(this);
        }
        if (_traceCacheCreation) {
            this.name2CreationStackTrace = new HashMap<String, StackTrace>();
        }
        this.logPhase("open");
    }

    private void logPhase(String _phase) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(_phase + " name=" + this.name + ", id=" + Integer.toString(System.identityHashCode((Object)this), 36) + ", classloaderId=" + Integer.toString(System.identityHashCode(this.classLoader), 36));
        }
    }

    public static Iterable<CacheLifeCycleListener> getCacheLifeCycleListeners() {
        return cacheLifeCycleListeners;
    }

    public void sendCreatedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheCreated(c);
        }
    }

    private void sendDestroyedEvent(Cache c) {
        for (CacheLifeCycleListener e : cacheLifeCycleListeners) {
            e.cacheDestroyed(c);
        }
    }

    public static void checkName(String s) {
        for (char c : s.toCharArray()) {
            if (c == '.' || c == '-' || c == '~' || c == ',' || c == '@' || c == ' ' || c == '(' || c == ')' || c == '+' || c == '!' || c == '\'' || c == '%' || c == '#' || c >= ' ' && c < '\u007f' && Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("Cache name contains illegal character: '" + c + "', name=\"" + s + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newCache(InternalCache c, String _requestedName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            String _name = _requestedName;
            if (this.cacheNames.containsKey(_name)) {
                throw new IllegalArgumentException("duplicate name: '" + _requestedName + "'");
            }
            CacheManagerImpl.checkName(_name);
            if (this.name2CreationStackTrace != null) {
                this.name2CreationStackTrace.put(_name, new StackTrace());
            }
            this.cacheNames.put(_name, c);
            return _name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheDestroyed(Cache c) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheNames.remove(c.getName());
            this.sendDestroyedEvent(c);
        }
    }

    public boolean isDefaultManager() {
        return this.defaultManager;
    }

    public String getName() {
        return this.name;
    }

    public Iterable<Cache> getActiveCaches() {
        return this.cachesCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Cache> cachesCopy() {
        HashSet<Cache> _caches = new HashSet<Cache>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                for (Cache cache : this.cacheNames.values()) {
                    if (cache.isClosed()) continue;
                    _caches.add(cache);
                }
            }
        }
        return _caches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String name) {
        Object object = this.lock;
        synchronized (object) {
            Cache c = this.cacheNames.get(name);
            return c != null && c.isClosed() ? null : c;
        }
    }

    public <K, V> Cache<K, V> createCache(Cache2kConfiguration<K, V> cfg) {
        return Cache2kBuilder.of(cfg).manager((CacheManager)this).build();
    }

    public void clear() {
        for (Cache c : this.cachesCopy()) {
            try {
                c.clear();
            }
            catch (CacheClosedException cacheClosedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Iterable<Cache> _caches;
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            _caches = this.cachesCopy();
            this.closing = true;
        }
        this.logPhase("close");
        ArrayList<Throwable> _suppressedExceptions = new ArrayList<Throwable>();
        for (Cache c : _caches) {
            ((InternalCache)c).cancelTimerJobs();
        }
        for (Cache c : _caches) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                _suppressedExceptions.add(throwable);
            }
        }
        try {
            for (CacheManagerLifeCycleListener lc : cacheManagerLifeCycleListeners) {
                lc.managerDestroyed(this);
            }
        }
        catch (Throwable t) {
            _suppressedExceptions.add(t);
        }
        ((Cache2kCoreProviderImpl)PROVIDER).removeManager(this);
        Object object2 = this.lock;
        synchronized (object2) {
            for (Cache cache : this.cacheNames.values()) {
                this.log.warn("unable to close cache: " + cache.getName());
            }
        }
        CacheManagerImpl.eventuallyThrowException(_suppressedExceptions);
        this.cacheNames = null;
    }

    static void eventuallyThrowException(List<Throwable> _suppressedExceptions) {
        if (_suppressedExceptions.isEmpty()) {
            return;
        }
        Throwable _error = null;
        for (Throwable t : _suppressedExceptions) {
            if (t instanceof Error) {
                _error = t;
                break;
            }
            if (!(t instanceof ExecutionException) || !(t.getCause() instanceof Error)) continue;
            _error = t.getCause();
            break;
        }
        String _text = "Exception(s) during shutdown";
        if (_suppressedExceptions.size() > 1) {
            _text = " (" + (_suppressedExceptions.size() - 1) + " more suppressed exceptions)";
        }
        if (_error != null) {
            throw new CacheInternalError(_text, _error);
        }
        throw new CacheException(_text, _suppressedExceptions.get(0));
    }

    public boolean isClosed() {
        return this.closing;
    }

    public Object getLockObject() {
        return this.lock;
    }

    private void checkClosed() {
        if (this.closing) {
            throw new IllegalStateException("CacheManager already closed");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getVersion() {
        return this.provider.getVersion();
    }

    public String getBuildNumber() {
        return this.provider.getBuildNumber();
    }

    public Cache2kCoreProviderImpl getProvider() {
        return this.provider;
    }

    static class StackTrace
    extends Exception {
        StackTrace() {
        }
    }
}

