/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.ConcurrentMapWrapper;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.common.BaseCacheControl;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.operation.CacheControl;
import org.cache2k.operation.CacheInfo;
import org.cache2k.operation.CacheOperation;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public abstract class BaseCache<K, V>
implements InternalCache<K, V> {
    public CompletableFuture<Void> reloadAll(Iterable<? extends K> keys) {
        CompletionWrapper w = new CompletionWrapper();
        this.reloadAll(keys, w);
        return w.future;
    }

    public CompletableFuture<Void> loadAll(Iterable<? extends K> keys) {
        CompletionWrapper w = new CompletionWrapper();
        this.loadAll(keys, w);
        return w.future;
    }

    public abstract Executor getExecutor();

    protected abstract <R> EntryAction<K, V, R> createFireAndForgetAction(Entry<K, V> var1, Semantic<K, V, R> var2);

    public static String nameQualifier(Cache<?, ?> cache) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(cache.getName()).append('\'');
        if (!cache.getCacheManager().isDefaultManager()) {
            sb.append(", manager='").append(cache.getCacheManager().getName()).append('\'');
        }
        return sb.toString();
    }

    protected abstract Iterator<CacheEntry<K, V>> iterator();

    public Set<K> keys() {
        return this.asMap().keySet();
    }

    public Set<CacheEntry<K, V>> entries() {
        return new AbstractSet<CacheEntry<K, V>>(){

            @Override
            public Iterator<CacheEntry<K, V>> iterator() {
                return BaseCache.this.iterator();
            }

            @Override
            public int size() {
                return BaseCache.this.getTotalEntryCount();
            }
        };
    }

    public void removeAll() {
        this.removeAll(this.keys());
    }

    public void removeAll(Iterable<? extends K> keys) {
        for (K k : keys) {
            this.remove(k);
        }
    }

    public <X> X requestInterface(Class<X> type) {
        if (type.equals(ConcurrentMap.class) || type.equals(Map.class)) {
            return (X)this.asMap();
        }
        if (type.isAssignableFrom(CacheOperation.class) || type.isAssignableFrom(CacheInfo.class) || type.isAssignableFrom(CacheControl.class)) {
            return (X)new BaseCacheControl(this);
        }
        if (type.isAssignableFrom(this.getClass())) {
            return (X)this;
        }
        throw new UnsupportedOperationException();
    }

    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMapWrapper(this);
    }

    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        HashMap<K, Object> m = new HashMap<K, Object>();
        for (K k : keys) {
            try {
                final Object result = this.invoke(k, entryProcessor);
                if (result == null) continue;
                m.put(k, new EntryProcessingResult<R>(){

                    public R getResult() {
                        return result;
                    }

                    public Throwable getException() {
                        return null;
                    }
                });
            }
            catch (EntryProcessingException t) {
                final Throwable cause = t.getCause();
                m.put(k, new EntryProcessingResult<R>(){

                    public R getResult() {
                        throw new EntryProcessingException(cause);
                    }

                    public Throwable getException() {
                        return cause;
                    }
                });
            }
        }
        return Collections.unmodifiableMap(m);
    }

    public void expireAt(K key, long millis) {
        this.execute(key, Operations.SINGLETON.expire(key, millis));
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> action = this.createEntryAction(key, e, op);
        return this.execute(action);
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    protected <R> R execute(EntryAction<K, V, R> action) {
        action.start();
        return this.finishExecution(action);
    }

    protected <R> R finishExecution(EntryAction<K, V, R> action) {
        RuntimeException t = action.exceptionToPropagate;
        if (t != null) {
            t.fillInStackTrace();
            throw t;
        }
        return action.result;
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    @Override
    public void closeCustomization(Object customization, String customizationName) {
        if (customization instanceof AutoCloseable) {
            try {
                ((AutoCloseable)customization).close();
            }
            catch (Exception e) {
                String message = customizationName + ".close() exception (" + BaseCache.nameQualifier(this) + ")";
                throw new CacheException(message, (Throwable)e);
            }
        }
    }

    public String toString() {
        try {
            InternalCacheInfo fo = this.getLatestInfo();
            return fo.toString();
        }
        catch (CacheClosedException ex) {
            return "Cache(name=" + BaseCache.nameQualifier(this) + ", closed=true)";
        }
    }

    static class CompletionWrapper
    implements CacheOperationCompletionListener {
        final CompletableFuture<Void> future = new CompletableFuture();

        CompletionWrapper() {
        }

        public void onCompleted() {
            this.future.complete(null);
        }

        public void onException(Throwable exception) {
            this.future.completeExceptionally(exception);
        }
    }
}

