/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.cache2k.Cache;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.Entry;

public class Hash2<K, V> {
    private static final int INITIAL_HASH_SIZE = 64;
    private static final int HASH_LOAD_PERCENT = 64;
    private static final int LOCK_SEGMENTS;
    private static final int LOCK_MASK;
    private volatile int clearOrCloseCount = 0;
    private long segmentMaxFill;
    private Entry<K, V>[] entries;
    private final StampedLock[] locks = new StampedLock[LOCK_SEGMENTS];
    private final AtomicLong[] segmentSize;
    private final Cache cache;

    public Hash2(Cache cache) {
        int i;
        for (i = 0; i < LOCK_SEGMENTS; ++i) {
            this.locks[i] = new StampedLock();
        }
        this.segmentSize = new AtomicLong[LOCK_SEGMENTS];
        for (i = 0; i < LOCK_SEGMENTS; ++i) {
            this.segmentSize[i] = new AtomicLong();
        }
        this.initArray();
        this.cache = cache;
    }

    private void initArray() {
        int len = Math.max(64, LOCK_SEGMENTS * 4);
        this.entries = new Entry[len];
        this.calcMaxFill();
    }

    public long getEntryCapacity() {
        return (long)this.entries.length * 1L * 64L / 100L;
    }

    public long getSegmentMaxFill() {
        return this.segmentMaxFill;
    }

    private void calcMaxFill() {
        this.segmentMaxFill = this.getEntryCapacity() / (long)LOCK_SEGMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> lookup(K key, int hash, int keyValue) {
        StampedLock[] locks = this.locks;
        int si = hash & LOCK_MASK;
        StampedLock l = locks[si];
        long stamp = l.tryOptimisticRead();
        Entry<K, V>[] tab = this.entries;
        if (tab == null) {
            throw new CacheClosedException(this.cache);
        }
        int n = tab.length;
        int mask = n - 1;
        int idx = hash & mask;
        Entry e = tab[idx];
        while (e != null) {
            if (e.hashCode == keyValue && this.keyObjIsEqual(key, e)) {
                return e;
            }
            e = e.another;
        }
        if (l.validate(stamp)) {
            return null;
        }
        stamp = l.readLock();
        try {
            tab = this.entries;
            if (tab == null) {
                throw new CacheClosedException(this.cache);
            }
            n = tab.length;
            mask = n - 1;
            idx = hash & mask;
            e = tab[idx];
            while (e != null) {
                if (e.hashCode == keyValue && this.keyObjIsEqual(key, e)) {
                    Entry entry = e;
                    return entry;
                }
                e = e.another;
            }
            Entry<K, V> entry = null;
            return entry;
        }
        finally {
            l.unlockRead(stamp);
        }
    }

    protected boolean keyObjIsEqual(K key, Entry e) {
        Object ek = e.getKeyObj();
        return ek == key || ek.equals(key);
    }

    public Entry<K, V> insertWithinLock(Entry<K, V> e, int hash, int keyValue) {
        Object key = e.getKeyObj();
        int si = hash & LOCK_MASK;
        Entry<K, V>[] tab = this.entries;
        if (tab == null) {
            throw new CacheClosedException(this.cache);
        }
        int n = tab.length;
        int mask = n - 1;
        int idx = hash & mask;
        Entry f = tab[idx];
        while (f != null) {
            Object ek;
            if (f.hashCode == keyValue && ((ek = f.getKeyObj()) == key || ek.equals(key))) {
                return f;
            }
            f = f.another;
        }
        e.another = tab[idx];
        tab[idx] = e;
        this.segmentSize[si].incrementAndGet();
        return e;
    }

    public void checkExpand(int hash) {
        int si = hash & LOCK_MASK;
        long size = this.segmentSize[si].get();
        if (size > this.segmentMaxFill) {
            this.eventuallyExpand(si);
        }
    }

    public StampedLock getSegmentLock(int hash) {
        return this.locks[hash & LOCK_MASK];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Entry<K, V> e) {
        int hash = this.modifiedHashCode(e.hashCode);
        StampedLock[] locks = this.locks;
        int si = hash & LOCK_MASK;
        StampedLock l = locks[si];
        long stamp = l.writeLock();
        try {
            Entry<K, V>[] tab = this.entries;
            if (tab == null) {
                throw new CacheClosedException(this.cache);
            }
            int n = tab.length;
            int mask = n - 1;
            int idx = hash & mask;
            Entry f = tab[idx];
            if (f == e) {
                tab[idx] = f.another;
                this.segmentSize[si].decrementAndGet();
                boolean bl = true;
                return bl;
            }
            while (f != null) {
                Entry another = f.another;
                if (another == e) {
                    f.another = another.another;
                    this.segmentSize[si].decrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                f = another;
            }
        }
        finally {
            l.unlockWrite(stamp);
        }
        return false;
    }

    public boolean removeWithinLock(Entry<K, V> e, int hash) {
        int si = hash & LOCK_MASK;
        Entry<K, V>[] tab = this.entries;
        if (tab == null) {
            throw new CacheClosedException(this.cache);
        }
        int n = tab.length;
        int mask = n - 1;
        int idx = hash & mask;
        Entry f = tab[idx];
        if (f == e) {
            tab[idx] = f.another;
            this.segmentSize[si].decrementAndGet();
            return true;
        }
        while (f != null) {
            Entry another = f.another;
            if (another == e) {
                f.another = another.another;
                this.segmentSize[si].decrementAndGet();
                return true;
            }
            f = another;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventuallyExpand(int segmentIndex) {
        long[] stamps = this.lockAll();
        try {
            long size = this.segmentSize[segmentIndex].get();
            if (size <= this.segmentMaxFill) {
                return;
            }
            this.rehash();
        }
        finally {
            this.unlockAll(stamps);
        }
    }

    private long[] lockAll() {
        StampedLock[] locks = this.locks;
        int sn = locks.length;
        long[] stamps = new long[this.locks.length];
        for (int i = 0; i < sn; ++i) {
            StampedLock l = locks[i];
            stamps[i] = l.writeLock();
        }
        return stamps;
    }

    private void unlockAll(long[] stamps) {
        StampedLock[] locks = this.locks;
        int sn = locks.length;
        for (int i = 0; i < sn; ++i) {
            locks[i].unlockWrite(stamps[i]);
        }
    }

    protected int modifiedHashCode(int hc) {
        return hc;
    }

    void rehash() {
        Entry<K, V>[] src = this.entries;
        if (src == null) {
            throw new CacheClosedException(this.cache);
        }
        int sl = src.length;
        int n = sl * 2;
        int mask = n - 1;
        Entry[] tab = new Entry[n];
        long count = 0L;
        for (int i = 0; i < sl; ++i) {
            Entry e = src[i];
            while (e != null) {
                ++count;
                Entry next = e.another;
                int idx = this.modifiedHashCode(e.hashCode) & mask;
                e.another = tab[idx];
                tab[idx] = e;
                e = next;
            }
        }
        this.entries = tab;
        this.calcMaxFill();
    }

    public long getSize() {
        long sum = 0L;
        for (AtomicLong al : this.segmentSize) {
            sum += al.get();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runTotalLocked(Supplier<T> j) {
        long[] stamps = this.lockAll();
        try {
            T t = j.get();
            return t;
        }
        finally {
            this.unlockAll(stamps);
        }
    }

    public void clearWhenLocked() {
        for (AtomicLong aSegmentSize : this.segmentSize) {
            aSegmentSize.set(0L);
        }
        ++this.clearOrCloseCount;
        this.initArray();
    }

    public int getClearOrCloseCount() {
        return this.clearOrCloseCount;
    }

    public void close() {
        ++this.clearOrCloseCount;
        this.entries = null;
    }

    /*
     * WARNING - void declaration
     */
    public long calcEntryCount() {
        long count = 0L;
        for (Entry<K, V> entry : this.entries) {
            void var6_5;
            while (var6_5 != null) {
                ++count;
                Entry entry2 = var6_5.another;
            }
        }
        return count;
    }

    public Entry<K, V>[] getEntries() {
        return this.entries;
    }

    static {
        int ncpu = Runtime.getRuntime().availableProcessors();
        LOCK_SEGMENTS = 2 << 31 - Integer.numberOfLeadingZeros(ncpu);
        LOCK_MASK = LOCK_SEGMENTS - 1;
    }
}

