/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cache2k.CacheException;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.io.CacheLoaderException;

public class OperationCompletion<K> {
    final CacheOperationCompletionListener listener;
    int initialCount;
    volatile int countDown;
    volatile int exceptionCount;
    volatile Throwable exception;
    static final AtomicIntegerFieldUpdater<OperationCompletion> BULK_OP_COUNT = AtomicIntegerFieldUpdater.newUpdater(OperationCompletion.class, "countDown");
    static final AtomicIntegerFieldUpdater<OperationCompletion> BULK_OP_EXCEPTION_COUNT = AtomicIntegerFieldUpdater.newUpdater(OperationCompletion.class, "exceptionCount");
    static final AtomicReferenceFieldUpdater<OperationCompletion, Throwable> BULK_OP_EXCEPTION = AtomicReferenceFieldUpdater.newUpdater(OperationCompletion.class, Throwable.class, "exception");

    public OperationCompletion(Set<K> keys, CacheOperationCompletionListener l) {
        this.initialCount = this.countDown = keys.size();
        this.listener = l;
    }

    public void complete(K key, Throwable t) {
        int i;
        if (t != null) {
            BULK_OP_EXCEPTION_COUNT.incrementAndGet(this);
            BULK_OP_EXCEPTION.compareAndSet(this, null, t);
        }
        if ((i = BULK_OP_COUNT.decrementAndGet(this)) == 0) {
            this.allCompleted();
        }
    }

    private void allCompleted() {
        if (this.exceptionCount == 0) {
            this.listener.onCompleted();
        } else if (this.exceptionCount == 1) {
            this.listener.onException((Throwable)this.wrap(null, this.exception));
        } else {
            this.listener.onException((Throwable)this.wrap("finished with " + this.exceptionCount + " exceptions out of " + this.initialCount + " operations, one propagated as cause", this.exception));
        }
    }

    CacheException wrap(String txt, Throwable t) {
        if (txt == null) {
            return new CacheLoaderException(t);
        }
        return new CacheLoaderException(txt, t);
    }
}

