/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.function.Supplier;
import org.cache2k.core.Entry;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.EvictionFactory;
import org.cache2k.core.eviction.EvictionMetrics;

public class SegmentedEviction
implements Eviction,
EvictionMetrics {
    private final Eviction[] segments;

    public SegmentedEviction(Eviction[] segments) {
        this.segments = segments;
    }

    @Override
    public boolean updateWeight(Entry e) {
        int hc = e.hashCode;
        Eviction[] sgs = this.segments;
        int mask = sgs.length - 1;
        int idx = hc & mask;
        return sgs[idx].updateWeight(e);
    }

    @Override
    public boolean submitWithoutTriggeringEviction(Entry e) {
        int hc = e.hashCode;
        Eviction[] sgs = this.segments;
        int mask = sgs.length - 1;
        int idx = hc & mask;
        return sgs[idx].submitWithoutTriggeringEviction(e);
    }

    @Override
    public void evictEventuallyBeforeInsertOnSegment(int hashCodeHint) {
        Eviction[] sgs = this.segments;
        int mask = sgs.length - 1;
        int idx = hashCodeHint & mask;
        sgs[idx].evictEventuallyBeforeInsertOnSegment(hashCodeHint);
    }

    @Override
    public void evictEventuallyBeforeInsert() {
        for (Eviction ev : this.segments) {
            ev.evictEventuallyBeforeInsert();
        }
    }

    @Override
    public void evictEventually() {
        for (Eviction ev : this.segments) {
            ev.evictEventually();
        }
    }

    @Override
    public long removeAll() {
        long count = 0L;
        for (Eviction ev : this.segments) {
            count += ev.removeAll();
        }
        return count;
    }

    @Override
    public void start() {
        for (Eviction ev : this.segments) {
            ev.start();
        }
    }

    @Override
    public void stop() {
        for (Eviction ev : this.segments) {
            ev.stop();
        }
    }

    @Override
    public void close() {
        for (Eviction ev : this.segments) {
            ev.close();
        }
    }

    @Override
    public boolean drain() {
        boolean f = false;
        for (Eviction ev : this.segments) {
            f |= ev.drain();
        }
        return f;
    }

    @Override
    public <T> T runLocked(Supplier<T> j) {
        return this.runLocked(0, j);
    }

    private <T> T runLocked(int idx, Supplier<T> j) {
        if (idx == this.segments.length) {
            return j.get();
        }
        return (T)this.segments[idx].runLocked(() -> this.runLocked(idx + 1, j));
    }

    @Override
    public void checkIntegrity(IntegrityState integrityState) {
        for (int i = 0; i < this.segments.length; ++i) {
            integrityState.group("eviction" + i);
            this.segments[i].checkIntegrity(integrityState);
        }
    }

    @Override
    public EvictionMetrics getMetrics() {
        return this;
    }

    @Override
    public String getExtraStatistics() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("eviction").append(i).append('(');
            sb.append(this.segments[i].getMetrics().getExtraStatistics());
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public long getHitCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getHitCount();
        }
        return sum;
    }

    @Override
    public long getNewEntryCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getNewEntryCount();
        }
        return sum;
    }

    @Override
    public long getRemovedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getRemovedCount();
        }
        return sum;
    }

    @Override
    public long getExpiredRemovedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getExpiredRemovedCount();
        }
        return sum;
    }

    @Override
    public long getVirginRemovedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getVirginRemovedCount();
        }
        return sum;
    }

    @Override
    public long getEvictedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getEvictedCount();
        }
        return sum;
    }

    @Override
    public long getSize() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getSize();
        }
        return sum;
    }

    @Override
    public long getMaxSize() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            long l = ev.getMetrics().getMaxSize();
            if (l == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            sum += l;
        }
        if (sum < 0L) {
            return -1L;
        }
        return sum;
    }

    @Override
    public long getMaxWeight() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            long l = ev.getMetrics().getMaxWeight();
            if (l == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            sum += l;
        }
        if (sum < 0L) {
            return -1L;
        }
        return sum;
    }

    @Override
    public long getTotalWeight() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            long l = ev.getMetrics().getTotalWeight();
            sum += l;
        }
        return sum;
    }

    @Override
    public int getEvictionRunningCount() {
        int sum = 0;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getEvictionRunningCount();
        }
        return sum;
    }

    @Override
    public long getEvictedWeight() {
        int sum = 0;
        for (Eviction ev : this.segments) {
            sum = (int)((long)sum + ev.getMetrics().getEvictedWeight());
        }
        return sum;
    }

    @Override
    public boolean isWeigherPresent() {
        return this.segments[0].isWeigherPresent();
    }

    @Override
    public void changeCapacity(long entryCountOrWeight) {
        long limitPerSegment = this.isWeigherPresent() ? EvictionFactory.determineMaxWeight(entryCountOrWeight, this.segments.length) : EvictionFactory.determineMaxSize(entryCountOrWeight, this.segments.length);
        for (Eviction ev : this.segments) {
            ev.changeCapacity(limitPerSegment);
        }
    }
}

