/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.eviction;

import org.cache2k.core.Entry;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.eviction.AbstractEviction;
import org.cache2k.core.eviction.HeapCacheForEviction;
import org.cache2k.operation.Weigher;

public class RandomEviction
extends AbstractEviction {
    private int evictionIndex = 0;
    private long size = 0L;
    private final Entry head = new Entry().shortCircuit();

    public RandomEviction(HeapCacheForEviction heapCache, HeapCacheListener listener, long maxSize, Weigher weigher, long maxWeight) {
        super(heapCache, listener, maxSize, weigher, maxWeight, false);
    }

    @Override
    public boolean updateWeight(Entry e) {
        return false;
    }

    @Override
    protected void removeFromReplacementList(Entry e) {
        Entry.removeFromList(e);
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.size;
        Entry.insertInList(this.head, e);
    }

    @Override
    protected Entry findEvictionCandidate() {
        Entry e;
        Entry<K, V>[] h0 = this.heapCache.getHashEntries();
        int idx = this.evictionIndex % h0.length;
        while ((e = h0[idx]) == null) {
            if (++idx < h0.length) continue;
            idx = 0;
        }
        this.evictionIndex += e.hashCode;
        if (this.evictionIndex < 0) {
            this.evictionIndex = -this.evictionIndex;
        }
        return e;
    }

    @Override
    public void checkIntegrity(IntegrityState integrityState) {
    }

    @Override
    protected long removeAllFromReplacementList() {
        long count = 0L;
        Entry head = this.head;
        Entry e = this.head.prev;
        while (e != head) {
            Entry next = e.prev;
            e.removedFromList();
            ++count;
            e = next;
        }
        return count;
    }

    @Override
    public String getExtraStatistics() {
        return "";
    }

    @Override
    public long getHitCount() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

