/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.IntArrays;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayAssert
extends AbstractAssert<IntArrayAssert, int[]>
implements EnumerableAssert<IntArrayAssert, Integer>,
ArraySortedAssert<IntArrayAssert, Integer> {
    @VisibleForTesting
    IntArrays arrays = IntArrays.instance();

    protected IntArrayAssert(int[] actual) {
        super(actual, IntArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (int[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (int[])this.actual);
    }

    @Override
    public IntArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (int[])this.actual);
        return this;
    }

    @Override
    public IntArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (int[])this.actual, expected);
        return this;
    }

    @Override
    public IntArrayAssert hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (int[])this.actual, other);
        return this;
    }

    @Override
    public IntArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (int[])this.actual, other);
        return this;
    }

    public IntArrayAssert contains(int ... values) {
        this.arrays.assertContains(this.info, (int[])this.actual, values);
        return this;
    }

    public IntArrayAssert containsOnly(int ... values) {
        this.arrays.assertContainsOnly(this.info, (int[])this.actual, values);
        return this;
    }

    public IntArrayAssert containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence(this.info, (int[])this.actual, sequence);
        return this;
    }

    public IntArrayAssert contains(int value, Index index) {
        this.arrays.assertContains(this.info, (int[])this.actual, value, index);
        return this;
    }

    public IntArrayAssert doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain(this.info, (int[])this.actual, values);
        return this;
    }

    public IntArrayAssert doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (int[])this.actual, value, index);
        return this;
    }

    public IntArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (int[])this.actual);
        return this;
    }

    public IntArrayAssert startsWith(int ... sequence) {
        this.arrays.assertStartsWith(this.info, (int[])this.actual, sequence);
        return this;
    }

    public IntArrayAssert endsWith(int ... sequence) {
        this.arrays.assertEndsWith(this.info, (int[])this.actual, sequence);
        return this;
    }

    @Override
    public IntArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (int[])this.actual);
        return this;
    }

    @Override
    public IntArrayAssert isSortedAccordingTo(Comparator<? super Integer> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (int[])this.actual, comparator);
        return this;
    }

    @Override
    public IntArrayAssert usingElementComparator(Comparator<? super Integer> customComparator) {
        this.arrays = new IntArrays((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (IntArrayAssert)this.myself;
    }

    @Override
    public IntArrayAssert usingDefaultElementComparator() {
        this.arrays = IntArrays.instance();
        return (IntArrayAssert)this.myself;
    }
}

