/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.Offset;
import org.fest.assertions.data.RgbColor;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.assertions.error.ShouldBeEqualColors;
import org.fest.assertions.error.ShouldBeEqualImages;
import org.fest.assertions.error.ShouldHaveSize;
import org.fest.assertions.error.ShouldNotBeEqualImages;
import org.fest.assertions.internal.ColorComparisonResult;
import org.fest.assertions.internal.CommonValidations;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Objects;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Images {
    private static final Images INSTANCE = new Images();
    private static final Offset<Integer> ZERO = Offset.offset(0);
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Images instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Images() {
    }

    public void assertEqual(AssertionInfo info, BufferedImage actual, BufferedImage expected) {
        this.assertEqual(info, actual, expected, ZERO);
    }

    public void assertEqual(AssertionInfo info, BufferedImage actual, BufferedImage expected, Offset<Integer> offset) {
        CommonValidations.checkOffsetIsNotNull(offset);
        if (org.fest.util.Objects.areEqual((Object)actual, (Object)expected)) {
            return;
        }
        if (actual == null || expected == null) {
            throw this.imagesShouldBeEqual(info, offset);
        }
        if (!this.haveEqualSize(actual, expected)) {
            throw this.imageShouldHaveSize(info, actual, Images.sizeOf(actual), Images.sizeOf(expected));
        }
        ColorComparisonResult haveEqualColor = this.haveEqualColor(actual, expected, offset);
        if (haveEqualColor == ColorComparisonResult.ARE_EQUAL) {
            return;
        }
        throw this.failures.failure(info, this.imagesShouldHaveEqualColor(haveEqualColor, offset));
    }

    private AssertionError imagesShouldBeEqual(AssertionInfo info, Offset<Integer> offset) {
        return this.failures.failure(info, ShouldBeEqualImages.shouldBeEqualImages(offset));
    }

    private ErrorMessageFactory imagesShouldHaveEqualColor(ColorComparisonResult r, Offset<Integer> offset) {
        return ShouldBeEqualColors.shouldBeEqualColors(r.color2, r.color1, r.point, offset);
    }

    public void assertNotEqual(AssertionInfo info, BufferedImage actual, BufferedImage other) {
        if (org.fest.util.Objects.areEqual((Object)actual, (Object)other)) {
            throw this.imagesShouldNotBeEqual(info);
        }
        if (actual == null || other == null) {
            return;
        }
        if (!this.haveEqualSize(actual, other)) {
            return;
        }
        ColorComparisonResult haveEqualColor = this.haveEqualColor(actual, other, ZERO);
        if (haveEqualColor != ColorComparisonResult.ARE_EQUAL) {
            return;
        }
        throw this.imagesShouldNotBeEqual(info);
    }

    private AssertionError imagesShouldNotBeEqual(AssertionInfo info) {
        return this.failures.failure(info, ShouldNotBeEqualImages.shouldNotBeEqualImages());
    }

    private boolean haveEqualSize(BufferedImage i1, BufferedImage i2) {
        return i1.getWidth() == i2.getWidth() && i1.getHeight() == i2.getHeight();
    }

    private ColorComparisonResult haveEqualColor(BufferedImage i1, BufferedImage i2, Offset<Integer> offset) {
        int w = i1.getWidth();
        int h = i1.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                RgbColor c2;
                RgbColor c1 = RgbColor.color(i1.getRGB(x, y));
                if (c1.isEqualTo(c2 = RgbColor.color(i2.getRGB(x, y)), offset)) continue;
                return ColorComparisonResult.notEqual(c1, c2, x, y);
            }
        }
        return ColorComparisonResult.ARE_EQUAL;
    }

    public void assertHasSize(AssertionInfo info, BufferedImage actual, Dimension size) {
        if (size == null) {
            throw new NullPointerException("The given size should not be null");
        }
        Objects.instance().assertNotNull(info, actual);
        Dimension sizeOfActual = Images.sizeOf(actual);
        if (org.fest.util.Objects.areEqual((Object)sizeOfActual, (Object)size)) {
            return;
        }
        throw this.imageShouldHaveSize(info, actual, sizeOfActual, size);
    }

    private AssertionError imageShouldHaveSize(AssertionInfo info, BufferedImage image, Dimension actual, Dimension expected) {
        return this.failures.failure(info, ShouldHaveSize.shouldHaveSize(image, actual, expected));
    }

    @VisibleForTesting
    static Dimension sizeOf(BufferedImage image) {
        return new Dimension(image.getWidth(), image.getHeight());
    }
}

