/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.internal.Comparables;
import org.fest.util.ComparisonStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Numbers<NUMBER extends Comparable<NUMBER>>
extends Comparables {
    public Numbers() {
    }

    public Numbers(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    protected abstract NUMBER zero();

    public void assertIsZero(AssertionInfo info, NUMBER actual) {
        this.assertEqualByComparison(info, actual, this.zero());
    }

    public void assertIsNotZero(AssertionInfo info, NUMBER actual) {
        this.assertNotEqualByComparison(info, actual, this.zero());
    }

    public void assertIsNegative(AssertionInfo info, NUMBER actual) {
        this.assertLessThan(info, actual, this.zero());
    }

    public void assertIsPositive(AssertionInfo info, NUMBER actual) {
        this.assertGreaterThan(info, actual, this.zero());
    }

    public void assertIsNotNegative(AssertionInfo info, NUMBER actual) {
        this.assertGreaterThanOrEqualTo(info, actual, this.zero());
    }

    public void assertIsNotPositive(AssertionInfo info, NUMBER actual) {
        this.assertLessThanOrEqualTo(info, actual, this.zero());
    }
}

