/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ImageReader {
    public static BufferedImage readImageFrom(String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("The path of the image to read should not be null");
        }
        File file = new File(path);
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("The path '%s' does not belong to a file", path));
        }
        return ImageIO.read(file);
    }

    private ImageReader() {
    }
}

