/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes.dataset;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbpm.xes.model.QueryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDefinitionLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDefinitionLoader.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final QueryDefinitionLoader INSTANCE = new QueryDefinitionLoader();

    private QueryDefinitionLoader() {
        MAPPER.registerModule((Module)new JaxbAnnotationModule());
    }

    public static QueryDefinitionLoader get() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<QueryDefinition> loadQueryDefinitions() {
        try (InputStream qdStream = this.getClass().getResourceAsStream("/default-query-definitions.json");){
            if (qdStream == null) {
                LOGGER.info("Default query definitions file default-query-definitions.json not found");
                List<QueryDefinition> list2 = Collections.emptyList();
                return list2;
            }
            List<QueryDefinition> list = this.loadQueryDefinitions(qdStream);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("Error when loading default query definitions from default-query-definitions.json", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected List<QueryDefinition> loadQueryDefinitions(InputStream qdStream) {
        try {
            QueryDefinition[] queries = (QueryDefinition[])MAPPER.readValue(qdStream, QueryDefinition[].class);
            LOGGER.info("Found {} query definitions", (Object)(queries == null ? 0 : queries.length));
            return queries == null ? Collections.emptyList() : Arrays.asList(queries);
        }
        catch (Exception e) {
            LOGGER.error("Error when unmarshalling query definitions from stream.", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

