/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import java.util.Set;

import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;


/**
 * @author Tom Baeyens
 */
public class AssignBinding extends JpdlBinding {

  public AssignBinding() {
    super("assign");
  }

  public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
    AssignActivity assignActivity = new AssignActivity();

    String variableName = XmlUtil.attribute(element, "var", true, parse);
    assignActivity.setVariableName(variableName);

    String expression = XmlUtil.attribute(element, "expr");
    if (expression!=null) {
      assignActivity.setExpression(expression);
      assignActivity.setLanguage(XmlUtil.attribute(element, "lang"));

    } else {
      
      Set<String> descriptorTagNames = JpdlParser.wireParser.getBindings().getTagNames(WireParser.CATEGORY_DESCRIPTOR);
      Descriptor valueDescriptor = null;
      List<Element> assignContentElements = XmlUtil.elements(element);
      
      for (int i=0; ((i<assignContentElements.size()) && (valueDescriptor==null)); i++) {
        Element assignContentElement = assignContentElements.get(i);
        String assignContentElementTagName = XmlUtil.getTagLocalName(assignContentElement);
        if (descriptorTagNames.contains(assignContentElementTagName)) {
          valueDescriptor = parser.parseDescriptor(element, parse);
        }
      }
      
      assignActivity.setValueDescriptor(valueDescriptor);
    }
    
    return assignActivity;
  }
}
