/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.action;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.flow.common.Activator;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalAutoLayoutAction
extends Action
implements IAction {
    public static final String ID = "org.jboss.tools.process.editor.action.VerticalAutoLayoutAction";
    private GraphicalViewer diagramViewer;

    public VerticalAutoLayoutAction(GraphicalViewer diagramViewer) {
        this.diagramViewer = diagramViewer;
        this.initialize();
    }

    protected void initialize() {
        this.setId(ID);
        this.setText("Auto Layout (Vertical)");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("icons/layoutV.gif")));
        this.setToolTipText("Auto layout the process (vertical)");
    }

    public void run() {
        HashMap<String, Node> mapping = new HashMap<String, Node>();
        DirectedGraph graph = this.createDirectedGraph(mapping);
        DirectedGraphLayout layout = new DirectedGraphLayout();
        layout.visit(graph);
        for (Map.Entry entry : mapping.entrySet()) {
            Node node = (Node)entry.getValue();
            NodeWrapper nodeWrapper = ((FlowWrapper)this.diagramViewer.getContents().getModel()).getElement((String)entry.getKey());
            nodeWrapper.setConstraint(new Rectangle(node.x, node.y, node.width, node.height));
        }
    }

    protected DirectedGraph createDirectedGraph(Map<String, Node> mapping) {
        DirectedGraph graph = new DirectedGraph();
        FlowWrapper processWrapper = (FlowWrapper)this.diagramViewer.getContents().getModel();
        for (NodeWrapper elementWrapper : processWrapper.getElements()) {
            Node node = new Node();
            Integer width = elementWrapper.getConstraint().width;
            Integer height = elementWrapper.getConstraint().height;
            if (width == null || width <= 0) {
                width = 80;
            }
            if (height == null || height <= 0) {
                height = 40;
            }
            node.setSize(new Dimension(width.intValue(), height.intValue()));
            graph.nodes.add((Object)node);
            mapping.put(elementWrapper.getId(), node);
        }
        for (NodeWrapper elementWrapper : processWrapper.getElements()) {
            for (ConnectionWrapper connection : elementWrapper.getIncomingConnections()) {
                Node source = mapping.get(connection.getSource().getId());
                Node target = mapping.get(connection.getTarget().getId());
                graph.edges.add((Object)new Edge(source, target));
            }
        }
        return graph;
    }
}

