/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.command;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

public class SplitConnectionCommand
extends Command {
    private FlowWrapper parent;
    private NodeWrapper oldSource;
    private NodeWrapper oldTarget;
    private ConnectionWrapper oldConnection;
    private ConnectionWrapper secondConnection;
    private NodeWrapper newElement;

    public void setNewSecondConnection(ConnectionWrapper connection) {
        if (connection == null) {
            throw new IllegalArgumentException("new second connection cannot be null");
        }
        this.secondConnection = connection;
    }

    public void execute() {
        if (this.secondConnection == null) {
            throw new IllegalStateException("new second connection is still null");
        }
        this.oldConnection.disconnect();
        this.parent.addElement(this.newElement);
        this.newElement.setParent(this.parent);
        this.oldConnection.connect(this.oldSource, this.newElement);
        this.secondConnection.connect(this.newElement, this.oldTarget);
    }

    public void setParent(FlowWrapper flow) {
        if (flow == null) {
            throw new IllegalArgumentException("process is null");
        }
        this.parent = flow;
    }

    public void setElementConnection(ConnectionWrapper connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Element connection is null");
        }
        this.oldConnection = connection;
        this.oldSource = connection.getSource();
        this.oldTarget = connection.getTarget();
    }

    public void setNewElement(NodeWrapper newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException("NewElement is null");
        }
        this.newElement = newElement;
    }

    public void undo() {
        this.oldConnection.disconnect();
        this.secondConnection.disconnect();
        this.parent.removeElement(this.newElement);
        this.newElement.setParent(null);
        this.oldConnection.connect(this.oldSource, this.oldTarget);
    }

    public boolean canExecute() {
        return this.parent.acceptsElement(this.newElement) && this.newElement.acceptsIncomingConnection(this.oldConnection, this.oldSource) && this.newElement.acceptsOutgoingConnection(this.secondConnection, this.oldTarget);
    }
}

