/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.editpart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.CreationFactory;
import org.jboss.tools.flow.common.policy.ConnectionBendpointEditPolicy;
import org.jboss.tools.flow.common.policy.ConnectionEditPolicy;
import org.jboss.tools.flow.common.registry.ElementRegistry;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.LabelWrapper;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionEditPart
extends AbstractConnectionEditPart
implements ModelListener {
    public ConnectionWrapper getElementConnection() {
        return (ConnectionWrapper)this.getModel();
    }

    public List<Wrapper> getModelChildren() {
        ArrayList<Wrapper> result = new ArrayList<Wrapper>();
        LabelWrapper label = this.getElementConnection().getLabel();
        if (label != null) {
            result.add(label);
        }
        return result;
    }

    protected void createEditPolicies() {
        ConnectionEditPolicy connectionEditPolicy = new ConnectionEditPolicy();
        connectionEditPolicy.setElementConnectionFactory(this.getElementConnectionFactory());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)connectionEditPolicy);
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionBendpointEditPolicy());
    }

    protected CreationFactory getElementConnectionFactory() {
        return ElementRegistry.getCreationFactory(this.getElementConnection().getElement());
    }

    protected Class<?> getElementConnectionType() {
        return DefaultConnectionWrapper.class;
    }

    protected IFigure createFigure() {
        PolylineConnection result = new PolylineConnection();
        result.setForegroundColor(ColorConstants.gray);
        result.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        result.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return result;
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(1);
        }
    }

    @Override
    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 1) {
            this.refreshBendpoints();
        }
    }

    public void activate() {
        super.activate();
        this.getElementConnection().addListener(this);
    }

    public void deactivate() {
        this.getElementConnection().removeListener(this);
        super.deactivate();
    }

    protected void refreshBendpoints() {
        List<Point> bendpoints = this.getElementConnection().getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint(bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
    }
}

