/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.multipage.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.flow.common.wrapper.Wrapper;
import org.jboss.tools.flow.jpdl4.editor.JpdlDeserializer;
import org.jboss.tools.flow.jpdl4.multipage.editors.InnerJpdlEditor;
import org.jboss.tools.flow.jpdl4.multipage.message.MultiPageMessages;

public class MultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private InnerJpdlEditor jpdlEditor;
    private StructuredTextEditor xmlEditor;

    public MultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    void createJpdl4EditorPage() {
        try {
            this.jpdlEditor = new InnerJpdlEditor();
            int pageNum = this.addPage((IEditorPart)this.jpdlEditor, this.getEditorInput());
            super.setPageText(pageNum, MultiPageMessages.Jpdl_Page_Name);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating Jpdl editor", null, (IStatus)e.getStatus());
        }
    }

    void createXmlEditorPage() {
        try {
            this.xmlEditor = new StructuredTextEditor();
            int pageNum = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            super.setPageText(pageNum, MultiPageMessages.Xml_Page_Name);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating xml editor", null, (IStatus)e.getStatus());
        }
    }

    protected void createPages() {
        this.createJpdl4EditorPage();
        this.createXmlEditorPage();
        super.setPartName(this.jpdlEditor.getPartName());
    }

    public void pageChange(int newPageIndex) {
        if (this.isDirty()) {
            if (this.getActiveEditor() instanceof StructuredTextEditor) {
                this.doPageChangeFromJpdlToXml();
            } else {
                this.doPageChangeFromXmlToJpdl();
            }
        }
        super.pageChange(newPageIndex);
    }

    private void doPageChangeFromXmlToJpdl() {
        String xmlText = this.xmlEditor.getDocumentProvider().getDocument((Object)this.xmlEditor.getEditorInput()).get();
        ByteArrayInputStream in = new ByteArrayInputStream(xmlText.getBytes());
        Wrapper model = new JpdlDeserializer().deserialize((InputStream)in);
        if (model != null && model.getElement() != null) {
            this.jpdlEditor.setModel(model);
            ((GraphicalViewer)this.jpdlEditor.getAdapter(GraphicalViewer.class)).setContents((Object)model);
        } else {
            System.out.println("Ha!");
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void doPageChangeFromJpdlToXml() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.jpdlEditor.writeModel(out);
            this.xmlEditor.getDocumentProvider().getDocument((Object)this.xmlEditor.getEditorInput()).set(out.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IEditorPart getActiveInnerEditor() {
        return this.getActiveEditor();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActiveEditor() instanceof StructuredTextEditor) {
            this.doPageChangeFromXmlToJpdl();
        }
        this.jpdlEditor.doSave(monitor);
        this.xmlEditor.doSave(monitor);
    }

    public void doSaveAs() {
        if (this.getActiveEditor() instanceof StructuredTextEditor) {
            this.doPageChangeFromXmlToJpdl();
        }
        this.jpdlEditor.doSaveAs();
        this.xmlEditor.doSave(null);
    }

    public boolean isSaveAsAllowed() {
        return this.jpdlEditor.isSaveAsAllowed();
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }
}

