/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.multipage.editors;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentRetargetAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.flow.common.Activator;
import org.jboss.tools.flow.common.editor.DropDownMenuWithDefaultAction;
import org.jboss.tools.flow.jpdl4.multipage.editors.InnerJpdlEditor;

public class MultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private ZoomComboContributionItem zoomCombo = null;
    private Map<String, RetargetAction> actionMap = new HashMap<String, RetargetAction>();
    private static final String[] WORKBENCH_ACTION_IDS = new String[]{ActionFactory.PRINT.getId(), ActionFactory.DELETE.getId(), ActionFactory.SAVE.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.FIND.getId(), IDEActionFactory.BOOKMARK.getId()};
    private static final String[] TEXTEDITOR_ACTION_IDS = new String[]{ITextEditorActionConstants.PRINT, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SAVE, ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO, ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND, IDEActionFactory.BOOKMARK.getId()};

    public void init(IActionBars bars) {
        this.buildActions(bars);
        this.contributeJpdlEditorToolBarAction(bars.getToolBarManager());
        super.init(bars);
    }

    public void setActivePage(IEditorPart activeEditor) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars == null) {
            return;
        }
        actionBars.clearGlobalActionHandlers();
        if (activeEditor instanceof InnerJpdlEditor) {
            this.addJpdlEditorActions((InnerJpdlEditor)activeEditor, actionBars);
        } else if (activeEditor instanceof StructuredTextEditor) {
            this.addXmlEditorActions((StructuredTextEditor)activeEditor, actionBars);
        }
        actionBars.updateActionBars();
    }

    private void addJpdlEditorActions(InnerJpdlEditor activeEditor, IActionBars actionBars) {
        ActionRegistry registry = (ActionRegistry)activeEditor.getAdapter(ActionRegistry.class);
        int i = 0;
        while (i < WORKBENCH_ACTION_IDS.length) {
            actionBars.setGlobalActionHandler(WORKBENCH_ACTION_IDS[i], registry.getAction((Object)WORKBENCH_ACTION_IDS[i]));
            ++i;
        }
        String[] keys = this.actionMap.keySet().toArray(new String[this.actionMap.keySet().size()]);
        int i2 = 0;
        while (i2 < keys.length) {
            actionBars.setGlobalActionHandler(keys[i2], registry.getAction((Object)keys[i2]));
            ++i2;
        }
        this.zoomCombo.setVisible(true);
        actionBars.getToolBarManager().update(true);
    }

    private void addXmlEditorActions(StructuredTextEditor activeEditor, IActionBars actionBars) {
        String[] keys = this.actionMap.keySet().toArray(new String[this.actionMap.keySet().size()]);
        int i = 0;
        while (i < keys.length) {
            actionBars.setGlobalActionHandler(keys[i], null);
            ++i;
        }
        i = 0;
        while (i < WORKBENCH_ACTION_IDS.length) {
            actionBars.setGlobalActionHandler(WORKBENCH_ACTION_IDS[i], activeEditor.getAction(TEXTEDITOR_ACTION_IDS[i]));
            ++i;
        }
        this.zoomCombo.setVisible(false);
    }

    private void buildActions(IActionBars actionBars) {
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomInRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomOutRetargetAction());
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(1));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(2));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(4));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(8));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(16));
        this.addRetargetAction((RetargetAction)new AlignmentRetargetAction(32));
        this.addRetargetAction(new RetargetAction("org.eclipse.gef.toggle_grid_visibility", "Grid"));
        RetargetAction verticalAutoLayoutAction = new RetargetAction("org.jboss.tools.process.editor.action.VerticalAutoLayoutAction", null);
        verticalAutoLayoutAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("icons/layoutV.gif")));
        this.addRetargetAction(verticalAutoLayoutAction);
        RetargetAction horizontalAutoLayoutAction = new RetargetAction("org.jboss.tools.process.editor.action.HorizontalAutoLayoutAction", null);
        horizontalAutoLayoutAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("icons/layoutH.gif")));
        this.addRetargetAction(horizontalAutoLayoutAction);
    }

    protected void addRetargetAction(RetargetAction action) {
        this.actionMap.put(action.getId(), action);
        this.getPage().addPartListener((IPartListener)action);
    }

    public void contributeJpdlEditorToolBarAction(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.actionMap.get(ActionFactory.UNDO.getId()));
        toolBarManager.add((IAction)this.actionMap.get(ActionFactory.REDO.getId()));
        toolBarManager.add((IContributionItem)new Separator());
        this.zoomCombo = new ZoomComboContributionItem((IPartService)this.getPage());
        toolBarManager.add((IContributionItem)this.zoomCombo);
        toolBarManager.add((IContributionItem)new Separator());
        DropDownMenuWithDefaultAction alignMenu = new DropDownMenuWithDefaultAction((IAction)this.actionMap.get("org.eclipse.gef.align_left"));
        alignMenu.add((IAction)this.actionMap.get("org.eclipse.gef.align_left"));
        alignMenu.add((IAction)this.actionMap.get("org.eclipse.gef.align_center"));
        alignMenu.add((IAction)this.actionMap.get("org.eclipse.gef.align_right"));
        alignMenu.add((IContributionItem)new Separator());
        alignMenu.add((IAction)this.actionMap.get("org.eclipse.gef.align_top"));
        alignMenu.add((IAction)this.actionMap.get("org.eclipse.gef.align_middle"));
        alignMenu.add((IAction)this.actionMap.get("org.eclipse.gef.align_bottom"));
        toolBarManager.add((IAction)alignMenu);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionMap.get("org.eclipse.gef.toggle_grid_visibility"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionMap.get("org.jboss.tools.process.editor.action.VerticalAutoLayoutAction"));
        toolBarManager.add((IAction)this.actionMap.get("org.jboss.tools.process.editor.action.HorizontalAutoLayoutAction"));
    }

    public void dispose() {
        String[] keys = this.actionMap.keySet().toArray(new String[this.actionMap.keySet().size()]);
        int i = 0;
        while (i < keys.length) {
            RetargetAction action = this.actionMap.get(keys[i]);
            this.getPage().removePartListener((IPartListener)action);
            action.dispose();
            ++i;
        }
        this.actionMap.clear();
        this.actionMap = null;
        this.zoomCombo.dispose();
    }
}

