/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.flow.jpdl4.Logger;
import org.jboss.tools.flow.jpdl4.wizard.NewJpdl4FileWizardPage;

public class NewJpdl4FileWizard
extends Wizard
implements IWorkbenchWizard {
    private static String ID_PROP_SHEET = "org.eclipse.ui.views.PropertySheet";
    private IStructuredSelection selection;
    private NewJpdl4FileWizardPage newFileWizardPage;

    public NewJpdl4FileWizard() {
        this.setWindowTitle("New jPDL4 File");
    }

    public void addPages() {
        this.newFileWizardPage = new NewJpdl4FileWizardPage(this.selection);
        this.addPage((IWizardPage)this.newFileWizardPage);
    }

    private IWorkbenchWindow getActiveWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench == null ? null : workbench.getActiveWorkbenchWindow();
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = this.getActiveWindow();
        return window == null ? null : window.getActivePage();
    }

    public boolean performFinish() {
        IFile file = this.newFileWizardPage.createNewFile();
        IWorkbenchPage activePage = this.getActivePage();
        if (file != null && activePage != null) {
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
                activePage.showView(ID_PROP_SHEET);
                BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)this.getActiveWindow());
                return true;
            }
            catch (PartInitException e) {
                Logger.logError("Exception while opening jPDL 4 editor", e);
            }
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

