/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jbpm.pvm.internal.ant.Launcher;

public class StartJBossTask
extends Task {
    private static final String END_MESSAGE = " Started in ";
    String configuration = null;
    String jbosshome = null;

    public void execute() throws BuildException {
        try {
            String fileSeparator = System.getProperty("file.separator");
            String os = this.getProject().getProperty("os.name").toLowerCase();
            String command = null;
            if (os.indexOf("windows") != -1) {
                command = this.getJBossHome() + fileSeparator + "bin" + fileSeparator + "run.bat " + this.getConfigParameter();
            } else if (os.indexOf("linux") != -1 || os.indexOf("mac") != -1) {
                command = this.getJBossHome() + fileSeparator + "bin" + fileSeparator + "run.sh " + this.getConfigParameter();
            } else {
                throw new BuildException("os '" + os + "' not supported in the startjboss task.");
            }
            Launcher launcher = new Launcher(this, command, END_MESSAGE);
            launcher.start();
            launcher.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String getJBossHome() {
        if (this.jbosshome != null) {
            return this.jbosshome;
        }
        String jbossHomeSysProp = this.getProject().getProperty("jboss.home");
        if (jbossHomeSysProp != null) {
            return jbossHomeSysProp;
        }
        throw new BuildException("startjboss couldn't figure out which jboss to start: attribute jbosshome not specified and property jboss.home was not set");
    }

    String getConfigParameter() {
        if (this.configuration == null) {
            return "";
        }
        return "-c " + this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setJbosshome(String jbosshome) {
        this.jbosshome = jbosshome;
    }
}

