/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.builder;

import org.jbpm.api.listener.EventListener;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.EventListenerReference;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.wire.Descriptor;

public class ObservableBuilder {
    protected ObservableElementImpl observableElement;
    protected String eventName;
    protected EventImpl event = null;

    public ObservableBuilder(ObservableElementImpl observableElement, String eventName) {
        this.observableElement = observableElement;
        this.eventName = eventName;
    }

    protected void addListener(EventListener eventListener) {
        this.getEvent().createEventListenerReference(eventListener);
    }

    protected void addListener(EventListener eventListener, boolean propagation) {
        EventListenerReference eventListenerReference = this.getEvent().createEventListenerReference(eventListener);
        eventListenerReference.setPropagationEnabled(propagation);
    }

    protected void addListener(Descriptor descriptor) {
        this.getEvent().createEventListenerReference(descriptor);
    }

    protected void addListener(Descriptor descriptor, boolean propagation) {
        EventListenerReference eventListenerReference = this.getEvent().createEventListenerReference(descriptor);
        eventListenerReference.setPropagationEnabled(propagation);
    }

    protected void addListener(String expression) {
        this.getEvent().createEventListenerReference(expression);
    }

    protected void addListener(String expression, boolean propagation) {
        EventListenerReference eventListenerReference = this.getEvent().createEventListenerReference(expression);
        eventListenerReference.setPropagationEnabled(propagation);
    }

    protected EventImpl getEvent() {
        if (this.event == null) {
            this.event = this.observableElement.createEvent(this.eventName);
        }
        return this.event;
    }
}

