/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.builder;

import java.util.Date;
import org.jbpm.api.listener.EventListener;
import org.jbpm.pvm.internal.builder.CompositeBuilder;
import org.jbpm.pvm.internal.builder.ObservableBuilder;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;

public class TimerBuilder
extends ObservableBuilder {
    protected CompositeBuilder compositeBuilder;
    protected TimerDefinitionImpl timerDefinition;

    public TimerBuilder(CompositeBuilder compositeBuilder, String eventName) {
        super(compositeBuilder.compositeElement, eventName);
        this.compositeBuilder = compositeBuilder;
        this.timerDefinition = compositeBuilder.compositeElement.createTimerDefinition();
    }

    public TimerBuilder dueDate(String dueDateCalendarExpression) {
        this.timerDefinition.setDueDateDescription(dueDateCalendarExpression);
        return this;
    }

    public TimerBuilder dueDate(Date dueDate) {
        this.timerDefinition.setDueDate(dueDate);
        return this;
    }

    public TimerBuilder repeat(String repeatCalendarExpression) {
        this.timerDefinition.setRepeat(repeatCalendarExpression);
        return this;
    }

    public TimerBuilder retries(int retries) {
        this.timerDefinition.setRetries(retries);
        return this;
    }

    public TimerBuilder signal(String signalName) {
        this.timerDefinition.setSignalName(signalName);
        return this;
    }

    public TimerBuilder decision() {
        this.timerDefinition.setExclusive(true);
        return this;
    }

    public TimerBuilder listener(EventListener eventListener) {
        this.addListener(eventListener);
        return this;
    }

    public TimerBuilder listener(EventListener eventListener, boolean propagation) {
        this.addListener(eventListener, propagation);
        return this;
    }

    public TimerBuilder listener(Descriptor descriptor) {
        this.addListener(descriptor);
        return this;
    }

    public TimerBuilder listener(Descriptor descriptor, boolean propagation) {
        this.addListener(descriptor, propagation);
        return this;
    }

    public TimerBuilder listener(String expression) {
        this.addListener(expression);
        return this;
    }

    public TimerBuilder listener(String expression, boolean propagation) {
        this.addListener(expression, propagation);
        return this;
    }

    public CompositeBuilder endTimer() {
        return this.compositeBuilder;
    }
}

