/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cfg;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.jbpm.api.Configuration;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.IdentityService;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Context;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.EnvironmentFactory;
import org.jbpm.pvm.internal.env.JbpmConfigurationParser;
import org.jbpm.pvm.internal.env.PvmEnvironment;
import org.jbpm.pvm.internal.env.WireObject;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.InputStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.StringStreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmConfiguration
extends Configuration
implements Context,
ProcessEngine,
EnvironmentFactory {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)JbpmConfiguration.class.getName());
    protected boolean isConfigured = false;
    protected WireContext processEngineWireContext = new WireContext(new WireDefinition(), "process-engine");
    protected WireDefinition transactionWireDefinition = new WireDefinition();

    public JbpmConfiguration() {
        super((Configuration)null);
    }

    public ProcessEngine buildProcessEngine() {
        if (!this.isConfigured) {
            this.setResource("jbpm.cfg.xml");
        }
        if (log.isTraceEnabled()) {
            log.trace("created ProcessEngine " + System.identityHashCode(this));
            if (this.processEngineWireContext != null && this.processEngineWireContext.getWireDefinition() != null && this.processEngineWireContext.getWireDefinition().getDescriptorTypes() != null) {
                log.trace("  process-engine-context " + System.identityHashCode(this.processEngineWireContext));
                for (Class<?> descriptorType : this.processEngineWireContext.getWireDefinition().getDescriptorTypes()) {
                    log.trace("    " + descriptorType.getName());
                }
            }
            if (this.transactionWireDefinition != null && this.transactionWireDefinition.getDescriptorTypes() != null) {
                log.trace("  transaction-context:");
                for (Class<?> descriptorType : this.transactionWireDefinition.getDescriptorTypes()) {
                    log.trace("    " + descriptorType.getName());
                }
            }
        }
        return this;
    }

    public void setSessionFactory(Object sessionFactory) {
        this.processEngineWireContext.getWireDefinition().addDescriptor(new ProvidedObjectDescriptor(sessionFactory, true));
    }

    public Configuration setInputStream(InputStream inputStream) {
        this.parse(new InputStreamInput(inputStream));
        return this;
    }

    public Configuration setResource(String resource) {
        this.parse(new ResourceStreamInput(resource, this.getClassLoader()));
        return this;
    }

    public Configuration setUrl(URL url) {
        this.parse(new UrlStreamInput(url));
        return this;
    }

    public Configuration setFile(File file) {
        this.parse(new FileStreamInput(file));
        return this;
    }

    public Configuration setXmlString(String xmlString) {
        this.parse(new StringStreamInput(xmlString));
        return this;
    }

    public static EnvironmentFactory parseXmlString(String xmlString) {
        JbpmConfiguration jbpmConfiguration = new JbpmConfiguration();
        jbpmConfiguration.setXmlString(xmlString);
        return jbpmConfiguration;
    }

    protected void parse(StreamInput streamSource) {
        this.isConfigured = true;
        JbpmConfigurationParser.getInstance().createParse().pushObject(this).setStreamSource(streamSource).execute().checkErrors("jbpm configuration " + streamSource);
    }

    public ExecutionService getExecutionService() {
        return this.processEngineWireContext.get(ExecutionService.class);
    }

    public HistoryService getHistoryService() {
        return this.processEngineWireContext.get(HistoryService.class);
    }

    public ManagementService getManagementService() {
        return this.processEngineWireContext.get(ManagementService.class);
    }

    public TaskService getTaskService() {
        return this.processEngineWireContext.get(TaskService.class);
    }

    public IdentityService getIdentityService() {
        return this.processEngineWireContext.get(IdentityService.class);
    }

    public RepositoryService getRepositoryService() {
        return this.processEngineWireContext.get(RepositoryService.class);
    }

    @Override
    public Environment openEnvironment() {
        return this.openEnvironment(null);
    }

    @Override
    public Environment openEnvironment(List<WireObject> txWireObjects) {
        ClassLoader classLoader;
        PvmEnvironment environment = new PvmEnvironment(this);
        if (log.isTraceEnabled()) {
            log.trace("opening " + environment);
        }
        if ((classLoader = this.processEngineWireContext.getClassLoader()) != null) {
            environment.setClassLoader(classLoader);
        }
        environment.setContext(this.processEngineWireContext);
        WireDefinition usedWireDefinition = this.transactionWireDefinition;
        if (txWireObjects != null) {
            usedWireDefinition = new WireDefinition(this.transactionWireDefinition, txWireObjects);
        }
        WireContext transactionContext = new WireContext(usedWireDefinition, "transaction", environment, true);
        environment.setContext(transactionContext);
        Environment.pushEnvironment(environment);
        try {
            transactionContext.create();
        }
        catch (RuntimeException e) {
            Environment.popEnvironment();
            throw e;
        }
        return environment;
    }

    @Override
    public void close() {
        this.processEngineWireContext.fire("close", null);
    }

    @Override
    public Object get(String key) {
        return this.processEngineWireContext.get(key);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.processEngineWireContext.get(type);
    }

    @Override
    public String getName() {
        return this.processEngineWireContext.getName();
    }

    @Override
    public boolean has(String key) {
        return this.processEngineWireContext.has(key);
    }

    @Override
    public Set<String> keys() {
        return this.processEngineWireContext.keys();
    }

    @Override
    public Object set(String key, Object value) {
        return this.processEngineWireContext.set(key, value);
    }

    public void addProcessEngineWireDefinition(WireDefinition wireDefinition) {
        this.processEngineWireContext.getWireDefinition().addWireDefinition(wireDefinition);
    }

    public void addTransactionWireDefinition(WireDefinition wireDefinition) {
        this.transactionWireDefinition.addWireDefinition(wireDefinition);
    }

    public void setTransactionWireDefinition(WireDefinition transactionWireDefinition) {
        this.transactionWireDefinition = transactionWireDefinition;
    }

    public WireContext getProcessEngineWireContext() {
        return this.processEngineWireContext;
    }

    public void setProcessEngineWireContext(WireContext processEngineWireContext) {
        this.processEngineWireContext = processEngineWireContext;
    }

    public WireDefinition getTransactionWireDefinition() {
        return this.transactionWireDefinition;
    }
}

