/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.history.model.HistoryCommentImpl;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddReplyCommentCmd
extends AbstractCommand<HistoryComment> {
    private static final long serialVersionUID = 1L;
    protected String commentId;
    protected String message;

    public AddReplyCommentCmd(String commentId, String message) {
        if (commentId == null) {
            throw new JbpmException("commentId is null");
        }
        this.commentId = commentId;
        this.message = message;
    }

    @Override
    public HistoryComment execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        HistoryCommentImpl parentComment = dbSession.get(HistoryCommentImpl.class, Long.parseLong(this.commentId));
        if (parentComment == null) {
            throw new JbpmException("parent comment doesn't exist: " + this.commentId);
        }
        HistoryCommentImpl replyComment = parentComment.createReply(this.message);
        return replyComment;
    }
}

