/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.RepositorySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDeploymentCmd
implements Command<Object> {
    private static final Log log = Log.getLog((String)DeleteDeploymentCmd.class.getName());
    private static final long serialVersionUID = 1L;
    String deploymentId;
    boolean cascade;

    public DeleteDeploymentCmd(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public DeleteDeploymentCmd(String deploymentId, boolean cascade) {
        this.deploymentId = deploymentId;
        this.cascade = cascade;
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        RepositorySession repositorySession = environment.get(RepositorySession.class);
        List processDefinitions = repositorySession.createProcessDefinitionQuery().deploymentId(this.deploymentId).list();
        DbSession dbSession = environment.get(DbSession.class);
        for (ProcessDefinition processDefinition : processDefinitions) {
            String processDefinitionId = processDefinition.getId();
            List<String> processInstanceIds = dbSession.findProcessInstanceIds(processDefinitionId);
            if (this.cascade) {
                for (String processInstanceId : processInstanceIds) {
                    dbSession.deleteProcessInstance(processInstanceId, true);
                }
                dbSession.deleteProcessDefinitionHistory(processDefinitionId);
                continue;
            }
            if (processInstanceIds.isEmpty()) continue;
            throw new JbpmException("cannot delete deployment " + this.deploymentId + ": still executions for " + processDefinition + ": " + processInstanceIds);
        }
        Session session = environment.get(Session.class);
        DeploymentImpl deployment = (DeploymentImpl)session.load(DeploymentImpl.class, (Serializable)Long.valueOf(Long.parseLong(this.deploymentId)));
        log.debug("deleting deployment " + this.deploymentId);
        session.delete((Object)deployment);
        RepositoryCache repositoryCache = environment.get(RepositoryCache.class);
        repositoryCache.set(this.deploymentId, null);
        return null;
    }
}

