/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.client.ClientExecution;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetExecutionVariablesCmd
extends AbstractCommand<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Set<String> variableNames;

    public GetExecutionVariablesCmd(String executionId, Set<String> variableNames) {
        if (executionId == null) {
            throw new JbpmException("executionId is null");
        }
        this.executionId = executionId;
        if (variableNames == null) {
            throw new JbpmException("variableNames is null");
        }
        this.variableNames = variableNames;
    }

    @Override
    public Map<String, Object> execute(Environment environment) throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        DbSession dbSession = environment.get(DbSession.class);
        ClientExecution execution = dbSession.findExecutionById(this.executionId);
        for (String variableName : this.variableNames) {
            Object value = execution.getVariable(variableName);
            variables.put(variableName, value);
        }
        return variables;
    }
}

