/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.session.RepositorySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetStartActivityNamesCmd
implements Command<List<String>> {
    private static final long serialVersionUID = 1L;
    String processDefinitionId;

    public GetStartActivityNamesCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public List<String> execute(Environment environment) {
        ArrayList<String> activityNames = new ArrayList<String>();
        RepositorySession repositorySession = Environment.getFromCurrent(RepositorySession.class);
        ProcessDefinitionImpl processDefinition = repositorySession.findProcessDefinitionById(this.processDefinitionId);
        for (ActivityImpl activityImpl : processDefinition.getActivities()) {
            if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
            activityNames.add(activityImpl.getName());
        }
        return activityNames;
    }
}

