/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.pvm.internal.client.ClientExecution;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalCmd
extends AbstractCommand<ProcessInstance> {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String signalName;
    protected Map<String, ?> parameters;

    public SignalCmd(String executionId, String signalName, Map<String, ?> parameters) {
        if (executionId == null) {
            throw new JbpmException("executionId is null");
        }
        this.executionId = executionId;
        this.signalName = signalName;
        this.parameters = parameters;
    }

    @Override
    public ProcessInstance execute(Environment environment) throws Exception {
        ClientExecution execution = null;
        DbSession dbSession = environment.get(DbSession.class);
        execution = dbSession.findExecutionById(this.executionId);
        if (execution == null) {
            throw new JbpmException("execution " + this.executionId + " does not exist");
        }
        execution.signal(this.signalName, this.parameters);
        return execution.getProcessInstance();
    }
}

