/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.client.ClientExecution;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariablesCmd<T>
extends AbstractCommand<T> {
    private static final long serialVersionUID = 1L;
    protected Map<String, ?> variables;
    private Map<String, Object> internalMap;

    public void addVariable(String key, Object variable) {
        if (this.internalMap == null) {
            if (this.variables != null) {
                throw new JbpmException("variables were set externally");
            }
            this.internalMap = new HashMap<String, Object>();
            this.variables = this.internalMap;
        }
        this.internalMap.put(key, variable);
    }

    public Map<String, ?> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, ?> variables) {
        this.variables = variables;
    }

    protected ClientExecution getExecution(Environment environment, String executionId) {
        DbSession dbSession = environment.get(DbSession.class);
        ClientExecution execution = dbSession.findExecutionById(executionId);
        if (execution == null) {
            throw new JbpmException("execution " + executionId + " doesn't exist");
        }
        return execution;
    }
}

