/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.email.impl;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.pvm.internal.email.spi.AddressResolver;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;

public class DefaultAddressResolver
implements AddressResolver {
    public Address resolveAddress(User user) {
        String givenName = user.getGivenName();
        String familyName = user.getFamilyName();
        String personal = givenName != null ? (familyName != null ? givenName + ' ' + familyName : givenName) : familyName;
        try {
            return new InternetAddress(user.getBusinessEmail(), personal);
        }
        catch (UnsupportedEncodingException e) {
            throw new JbpmException("invalid recipient name: " + personal);
        }
    }

    public Address[] resolveAddresses(Group group) {
        List<User> users = Environment.getFromCurrent(IdentitySession.class).findUsersByGroup(group.getId());
        int userCount = users.size();
        Address[] addresses = new Address[userCount];
        for (int i = 0; i < userCount; ++i) {
            addresses[i] = this.resolveAddress(users.get(i));
        }
        return addresses;
    }
}

